/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.replication;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.TransportActions;
import conductor.org.elasticsearch.action.support.WriteRequest;
import conductor.org.elasticsearch.action.support.WriteResponse;
import conductor.org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import conductor.org.elasticsearch.action.support.replication.ReplicationOperation;
import conductor.org.elasticsearch.action.support.replication.ReplicationResponse;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class TransportWriteAction<Request extends ReplicatedWriteRequest<Request>, ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<ReplicaRequest> replicaRequest, String executor) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, request, replicaRequest, executor, true);
    }

    protected static Translog.Location syncOperationResultOrThrow(Engine.Result operationResult, Translog.Location currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + failure;
            throw failure;
        }
        Translog.Location location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    protected ReplicationOperation.Replicas newReplicasProxy(long primaryTerm) {
        return new WriteActionReplicasProxy(primaryTerm);
    }

    @Override
    protected abstract WritePrimaryResult<ReplicaRequest, Response> shardOperationOnPrimary(Request var1, IndexShard var2) throws Exception;

    @Override
    protected abstract WriteReplicaResult<ReplicaRequest> shardOperationOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        WriteActionReplicasProxy(long primaryTerm) {
            super(primaryTerm);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn(new ParameterizedMessage("[{}] {}", (Object)replica.shardId(), (Object)message), (Throwable)exception);
            }
            TransportWriteAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), this.primaryTerm, true, message, exception, listener);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, ActionListener<Void> listener) {
            TransportWriteAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, this.primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean waitUntilRefresh;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;
        private final WriteRequest<?> request;
        private final Logger logger;

        AsyncAfterWriteAction(IndexShard indexShard, WriteRequest<?> request, @Nullable Translog.Location location, RespondingWriteResult respond, Logger logger) {
            this.indexShard = indexShard;
            this.request = request;
            boolean waitUntilRefresh = false;
            switch (request.getRefreshPolicy()) {
                case IMMEDIATE: {
                    indexShard.refresh("refresh_flag_index");
                    this.refreshed.set(true);
                    break;
                }
                case WAIT_UNTIL: {
                    if (location == null) break;
                    waitUntilRefresh = true;
                    this.pendingOps.incrementAndGet();
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown refresh policy: " + request.getRefreshPolicy());
                }
            }
            this.waitUntilRefresh = waitUntilRefresh;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            this.logger = logger;
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.waitUntilRefresh) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.addRefreshListener(this.location, forcedRefresh -> {
                    if (forcedRefresh.booleanValue()) {
                        this.logger.warn("block until refresh ran out of slots and forced a refresh: [{}]", (Object)this.request);
                    }
                    this.refreshed.set((boolean)forcedRefresh);
                    this.maybeFinish();
                });
            }
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    public static class WriteReplicaResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>>
    extends TransportReplicationAction.ReplicaResult
    implements RespondingWriteResult {
        public final Translog.Location location;
        boolean finishedAsyncActions;
        private ActionListener<TransportResponse.Empty> listener;

        public WriteReplicaResult(ReplicaRequest request, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica, Logger logger) {
            super(operationFailure);
            this.location = location;
            if (operationFailure != null) {
                this.finishedAsyncActions = true;
            } else {
                new AsyncAfterWriteAction(replica, (WriteRequest<?>)request, location, this, logger).run();
            }
        }

        @Override
        public synchronized void respond(ActionListener<TransportResponse.Empty> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            assert (Thread.holdsLock(this));
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public synchronized void onFailure(Exception ex) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(ex);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }

    public static class WritePrimaryResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>
    implements RespondingWriteResult {
        boolean finishedAsyncActions;
        public final Translog.Location location;
        public final IndexShard primary;
        ActionListener<Response> listener = null;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard primary, Logger logger) {
            super(request, finalResponse, operationFailure);
            this.location = location;
            this.primary = primary;
            assert (location == null || operationFailure == null) : "expected either failure to be null or translog location to be null, but found: [" + location + "] translog location and [" + operationFailure + "] failure";
            if (operationFailure != null) {
                this.finishedAsyncActions = true;
            } else {
                new AsyncAfterWriteAction(primary, (WriteRequest<?>)request, location, this, logger).run();
            }
        }

        @Override
        public synchronized void respond(ActionListener<Response> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            assert (Thread.holdsLock(this));
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public synchronized void onFailure(Exception exception) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(exception);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            ((WriteResponse)((Object)this.finalResponseIfSuccessful)).setForcedRefresh(forcedRefresh);
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }
}

