/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.client.security.RefreshPolicy;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import java.util.Objects;

public final class DeleteRoleMappingRequest
implements Validatable {
    private final String name;
    private final RefreshPolicy refreshPolicy;

    public DeleteRoleMappingRequest(String name, @Nullable RefreshPolicy refreshPolicy) {
        if (!Strings.hasText(name)) {
            throw new IllegalArgumentException("role-mapping name is required");
        }
        this.name = name;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getName() {
        return this.name;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.refreshPolicy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteRoleMappingRequest other = (DeleteRoleMappingRequest)obj;
        return this.refreshPolicy == other.refreshPolicy && Objects.equals(this.name, other.name);
    }
}

