/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.InjectorImpl;
import conductor.org.elasticsearch.common.inject.SingleMemberInjector;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.internal.ErrorsException;
import conductor.org.elasticsearch.common.inject.internal.InternalContext;
import conductor.org.elasticsearch.common.inject.internal.InternalFactory;
import conductor.org.elasticsearch.common.inject.spi.Dependency;
import conductor.org.elasticsearch.common.inject.spi.InjectionPoint;
import java.lang.reflect.Field;

class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final InternalFactory<?> factory;

    SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.factory = injector.getInternalFactory(this.dependency.getKey(), errors);
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o) {
        errors = errors.withSource(this.dependency);
        context.setDependency(this.dependency);
        try {
            Object value = this.factory.get(errors, context, this.dependency);
            this.field.set(o, value);
        }
        catch (ErrorsException e) {
            errors.withSource(this.injectionPoint).merge(e.getErrors());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            context.setDependency(null);
        }
    }
}

