/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.time;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.time.DateFormatters;
import conductor.org.joda.time.DateTimeZone;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DateUtils {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(DateFormatters.class));
    static final Map<String, String> DEPRECATED_SHORT_TIMEZONES;
    public static final Set<String> DEPRECATED_SHORT_TZ_IDS;

    public static DateTimeZone zoneIdToDateTimeZone(ZoneId zoneId) {
        if (zoneId == null) {
            return null;
        }
        if (zoneId instanceof ZoneOffset) {
            return DateTimeZone.forOffsetMillis(((ZoneOffset)zoneId).getTotalSeconds() * 1000);
        }
        return DateTimeZone.forID(zoneId.getId());
    }

    public static ZoneId dateTimeZoneToZoneId(DateTimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        if (DateTimeZone.UTC.equals(timeZone)) {
            return ZoneOffset.UTC;
        }
        String deprecatedId = DEPRECATED_SHORT_TIMEZONES.get(timeZone.getID());
        if (deprecatedId != null) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("timezone", "Use of short timezone id " + timeZone.getID() + " is deprecated. Use " + deprecatedId + " instead", new Object[0]);
            return ZoneId.of(deprecatedId);
        }
        return ZoneId.of(timeZone.getID());
    }

    static {
        HashMap<String, String> tzs = new HashMap<String, String>();
        tzs.put("EST", "-05:00");
        tzs.put("HST", "-10:00");
        tzs.put("MST", "-07:00");
        tzs.put("ROC", "Asia/Taipei");
        tzs.put("Eire", "Europe/London");
        DEPRECATED_SHORT_TIMEZONES = Collections.unmodifiableMap(tzs);
        DEPRECATED_SHORT_TZ_IDS = tzs.keySet();
    }
}

