/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.index.AbstractIndexComponent;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.fielddata.AtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import java.io.IOException;

public abstract class AbstractIndexFieldData<FD extends AtomicFieldData>
extends AbstractIndexComponent
implements IndexFieldData<FD> {
    private final String fieldName;
    protected final IndexFieldDataCache cache;

    public AbstractIndexFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache) {
        super(indexSettings);
        this.fieldName = fieldName;
        this.cache = cache;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void clear() {
        this.cache.clear(this.fieldName);
    }

    @Override
    public FD load(LeafReaderContext context) {
        if (context.reader().getFieldInfos().fieldInfo(this.fieldName) == null) {
            return this.empty(context.reader().maxDoc());
        }
        try {
            Object fd = this.cache.load(context, this);
            return fd;
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    protected abstract FD empty(int var1);

    public static interface PerValueEstimator {
        public long bytesPerValue(BytesRef var1);

        public TermsEnum beforeLoad(Terms var1) throws IOException;

        public void afterLoad(TermsEnum var1, long var2);
    }
}

