/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.fielddata.plain.BytesBinaryDVAtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.search.MultiValueMode;
import java.io.IOException;

public class BytesBinaryDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexFieldData<BytesBinaryDVAtomicFieldData> {
    public BytesBinaryDVIndexFieldData(Index index, String fieldName) {
        super(index, fieldName);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on binary field");
    }

    @Override
    public BytesBinaryDVAtomicFieldData load(LeafReaderContext context) {
        try {
            return new BytesBinaryDVAtomicFieldData(DocValues.getBinary(context.reader(), this.fieldName));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public BytesBinaryDVAtomicFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            return new BytesBinaryDVIndexFieldData(indexSettings.getIndex(), fieldName);
        }
    }
}

