/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.geo.GeoEncodingUtils;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import conductor.org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

final class LatLonPointDVAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    private final LeafReader reader;
    private final String fieldName;

    LatLonPointDVAtomicFieldData(LeafReader reader, String fieldName) {
        this.reader = reader;
        this.fieldName = fieldName;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }

    @Override
    public MultiGeoPointValues getGeoPointValues() {
        try {
            final SortedNumericDocValues numericValues = DocValues.getSortedNumeric(this.reader, this.fieldName);
            return new MultiGeoPointValues(){
                final GeoPoint point = new GeoPoint();

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return numericValues.advanceExact(doc);
                }

                @Override
                public int docValueCount() {
                    return numericValues.docValueCount();
                }

                @Override
                public GeoPoint nextValue() throws IOException {
                    long encoded = numericValues.nextValue();
                    this.point.reset(GeoEncodingUtils.decodeLatitude((int)(encoded >>> 32)), GeoEncodingUtils.decodeLongitude((int)encoded));
                    return this.point;
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

