/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.client.ParentTaskAssigningClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.index.reindex.TransportDeleteByQueryAction;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.threadpool.ThreadPool;

public class AsyncDeleteByQueryAction
extends AbstractAsyncBulkByScrollAction<DeleteByQueryRequest, TransportDeleteByQueryAction> {
    private final boolean allowSeqNoForCAS;

    public AsyncDeleteByQueryAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, TransportDeleteByQueryAction action, DeleteByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        super(task, true, clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0), logger, client, threadPool, action, request, listener);
        this.allowSeqNoForCAS = clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0);
    }

    @Override
    protected boolean accept(ScrollableHitSource.Hit doc) {
        return true;
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<DeleteRequest> buildRequest(ScrollableHitSource.Hit doc) {
        DeleteRequest delete = new DeleteRequest();
        delete.index(doc.getIndex());
        delete.type(doc.getType());
        delete.id(doc.getId());
        if (this.allowSeqNoForCAS && doc.getSeqNo() != -2L) {
            delete.setIfSeqNo(doc.getSeqNo());
            delete.setIfPrimaryTerm(doc.getPrimaryTerm());
        } else {
            assert (doc.getVersion() != -1L) : "no version retrieved";
            delete.version(doc.getVersion());
        }
        return AsyncDeleteByQueryAction.wrap(delete);
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<?> copyMetadata(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        request.setParent(doc.getParent());
        request.setRouting(doc.getRouting());
        return request;
    }
}

