/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.seqno;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.apache.lucene.store.AlreadyClosedException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.action.support.WriteResponse;
import conductor.org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import conductor.org.elasticsearch.action.support.replication.ReplicationOperation;
import conductor.org.elasticsearch.action.support.replication.ReplicationResponse;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.action.support.replication.TransportWriteAction;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.index.seqno.RetentionLeases;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.IndexShardClosedException;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Objects;

public class RetentionLeaseSyncAction
extends TransportWriteAction<Request, Request, Response> {
    public static String ACTION_NAME = "indices:admin/seq_no/retention_lease_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, Request::new, Request::new, "management");
    }

    public void sync(ShardId shardId, RetentionLeases retentionLeases, ActionListener<ReplicationResponse> listener) {
        Objects.requireNonNull(shardId);
        Objects.requireNonNull(retentionLeases);
        Objects.requireNonNull(listener);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId, retentionLeases), ActionListener.wrap(listener::onResponse, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    this.getLogger().warn(new ParameterizedMessage("{} retention lease sync failed", (Object)shardId), (Throwable)e);
                }
                listener.onFailure((Exception)e);
            }));
        }
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<Request, Response> shardOperationOnPrimary(Request request, IndexShard primary) throws IOException {
        assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
        Objects.requireNonNull(request);
        Objects.requireNonNull(primary);
        primary.persistRetentionLeases();
        return new TransportWriteAction.WritePrimaryResult<Request, Response>(request, new Response(), null, null, primary, this.getLogger());
    }

    @Override
    protected void sendReplicaRequest(TransportReplicationAction.ConcreteReplicaRequest<Request> replicaRequest, DiscoveryNode node, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
        if (node.getVersion().onOrAfter(Version.V_6_7_0)) {
            super.sendReplicaRequest(replicaRequest, node, listener);
        } else {
            listener.onResponse(new TransportReplicationAction.ReplicaResponse(-1L, -1L));
        }
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<Request> shardOperationOnReplica(Request request, IndexShard replica) throws IOException {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
        replica.persistRetentionLeases();
        return new TransportWriteAction.WriteReplicaResult<Request>(request, null, null, replica, this.getLogger());
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected Response newResponseInstance() {
        return new Response();
    }

    public static final class Response
    extends ReplicationResponse
    implements WriteResponse {
        @Override
        public void setForcedRefresh(boolean forcedRefresh) {
        }
    }

    public static final class Request
    extends ReplicatedWriteRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request() {
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public String toString() {
            return "Request{retentionLeases=" + this.retentionLeases + ", shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", waitForActiveShards=" + this.waitForActiveShards + '}';
        }
    }
}

