/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.shard.IndexShardState;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;

public class IllegalIndexShardStateException
extends ElasticsearchException {
    private final IndexShardState currentState;

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Object ... args) {
        this(shardId, currentState, msg, null, args);
    }

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Throwable ex, Object ... args) {
        super("CurrentState[" + (Object)((Object)currentState) + "] " + msg, ex, args);
        this.setShard(shardId);
        this.currentState = currentState;
    }

    public IndexShardState currentState() {
        return this.currentState;
    }

    public IllegalIndexShardStateException(StreamInput in) throws IOException {
        super(in);
        this.currentState = IndexShardState.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.currentState.id());
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }
}

