/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.store;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import conductor.org.elasticsearch.action.support.nodes.TransportNodesAction;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.gateway.AsyncShardFetch;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.index.store.StoreFileMetaData;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TransportNodesListShardStoreMetaData
extends TransportNodesAction<Request, NodesStoreFilesMetaData, NodeRequest, NodeStoreFilesMetaData>
implements AsyncShardFetch.Lister<NodesStoreFilesMetaData, NodeStoreFilesMetaData> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListShardStoreMetaData(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry namedXContentRegistry) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetaData.class);
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(ShardId shardId, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetaData> listener) {
        this.execute(new Request(shardId, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeStoreFilesMetaData newNodeResponse() {
        return new NodeStoreFilesMetaData();
    }

    @Override
    protected NodesStoreFilesMetaData newResponse(Request request, List<NodeStoreFilesMetaData> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetaData(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetaData nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetaData(this.clusterService.localNode(), this.listStoreMetaData(request.shardId));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to list store metadata for shard [" + request.shardId + "]", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private StoreFilesMetaData listStoreMetaData(ShardId shardId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class NodeStoreFilesMetaData
    extends BaseNodeResponse {
        private StoreFilesMetaData storeFilesMetaData;

        NodeStoreFilesMetaData() {
        }

        public NodeStoreFilesMetaData(DiscoveryNode node, StoreFilesMetaData storeFilesMetaData) {
            super(node);
            this.storeFilesMetaData = storeFilesMetaData;
        }

        public StoreFilesMetaData storeFilesMetaData() {
            return this.storeFilesMetaData;
        }

        public static NodeStoreFilesMetaData readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            NodeStoreFilesMetaData resp = new NodeStoreFilesMetaData();
            resp.readFrom(in);
            return resp;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.storeFilesMetaData = StoreFilesMetaData.readStoreFilesMetaData(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetaData.writeTo(out);
        }

        public String toString() {
            return "[[" + this.getNode() + "][" + this.storeFilesMetaData + "]]";
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private ShardId shardId;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(nodeId);
            this.shardId = request.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static class NodesStoreFilesMetaData
    extends BaseNodesResponse<NodeStoreFilesMetaData> {
        NodesStoreFilesMetaData() {
        }

        public NodesStoreFilesMetaData(ClusterName clusterName, List<NodeStoreFilesMetaData> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetaData> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetaData::readListShardStoreNodeOperationResponse);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetaData> nodes) throws IOException {
            out.writeStreamableList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private ShardId shardId;

        public Request() {
        }

        public Request(ShardId shardId, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static class StoreFilesMetaData
    implements Iterable<StoreFileMetaData>,
    Streamable {
        private ShardId shardId;
        Store.MetadataSnapshot metadataSnapshot;

        StoreFilesMetaData() {
        }

        public StoreFilesMetaData(ShardId shardId, Store.MetadataSnapshot metadataSnapshot) {
            this.shardId = shardId;
            this.metadataSnapshot = metadataSnapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public boolean isEmpty() {
            return this.metadataSnapshot.size() == 0;
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadataSnapshot.iterator();
        }

        public boolean fileExists(String name) {
            return this.metadataSnapshot.asMap().containsKey(name);
        }

        public StoreFileMetaData file(String name) {
            return this.metadataSnapshot.asMap().get(name);
        }

        public static StoreFilesMetaData readStoreFilesMetaData(StreamInput in) throws IOException {
            StoreFilesMetaData md = new StoreFilesMetaData();
            md.readFrom(in);
            return md;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.shardId = ShardId.readShardId(in);
            this.metadataSnapshot = new Store.MetadataSnapshot(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            this.metadataSnapshot.writeTo(out);
        }

        public String syncId() {
            return this.metadataSnapshot.getSyncId();
        }

        public String toString() {
            return "StoreFilesMetaData{, shardId=" + this.shardId + ", metadataSnapshot{size=" + this.metadataSnapshot.size() + ", syncId=" + this.metadataSnapshot.getSyncId() + "}" + '}';
        }
    }
}

