/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;
import java.util.Map;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPutMappingAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] The parameter include_type_name should be explicitly specified in put mapping requests to prepare for 7.0. In 7.0 include_type_name will default to 'false', and requests are expected to omit the type name in mapping definitions.";

    public RestPutMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mappings/{type}", this);
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName;
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        String type = request.param("type");
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (!request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("put_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (!(includeTypeName = request.paramAsBoolean("include_type_name", true)) && (type != null || MapperService.isMappingSourceTyped("_doc", sourceAsMap))) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests, unless the include_type_name parameter is set to true.");
        }
        putMappingRequest.type(includeTypeName ? type : "_doc");
        putMappingRequest.source(sourceAsMap);
        if (request.hasParam("update_all_types")) {
            deprecationLogger.deprecated("[update_all_types] is deprecated since indices may not have more than one type anymore", new Object[0]);
        }
        putMappingRequest.updateAllTypes(request.paramAsBoolean("update_all_types", false));
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

