/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.TransportSearchAction;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.script.ScriptType;
import conductor.org.elasticsearch.script.TemplateScript;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.SearchTemplateResponse;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilder;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Collections;

public class TransportSearchTemplateAction
extends HandledTransportAction<SearchTemplateRequest, SearchTemplateResponse> {
    private static final String TEMPLATE_LANG = "mustache";
    private final ScriptService scriptService;
    private final TransportSearchAction searchAction;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportSearchTemplateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, ScriptService scriptService, TransportSearchAction searchAction, NamedXContentRegistry xContentRegistry) {
        super(settings, "indices:data/read/search/template", threadPool, transportService, actionFilters, resolver, SearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.searchAction = searchAction;
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(SearchTemplateRequest request, final ActionListener<SearchTemplateResponse> listener) {
        final SearchTemplateResponse response = new SearchTemplateResponse();
        try {
            SearchRequest searchRequest = TransportSearchTemplateAction.convert(request, response, this.scriptService, this.xContentRegistry);
            if (searchRequest != null) {
                this.searchAction.execute(searchRequest, new ActionListener<SearchResponse>(){

                    @Override
                    public void onResponse(SearchResponse searchResponse) {
                        try {
                            response.setResponse(searchResponse);
                            listener.onResponse(response);
                        }
                        catch (Exception t) {
                            listener.onFailure(t);
                        }
                    }

                    @Override
                    public void onFailure(Exception t) {
                        listener.onFailure(t);
                    }
                });
            } else {
                listener.onResponse(response);
            }
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }

    static SearchRequest convert(SearchTemplateRequest searchTemplateRequest, SearchTemplateResponse response, ScriptService scriptService, NamedXContentRegistry xContentRegistry) throws IOException {
        Script script = new Script(searchTemplateRequest.getScriptType(), searchTemplateRequest.getScriptType() == ScriptType.STORED ? null : TEMPLATE_LANG, searchTemplateRequest.getScript(), searchTemplateRequest.getScriptParams() == null ? Collections.emptyMap() : searchTemplateRequest.getScriptParams());
        TemplateScript compiledScript = scriptService.compile(script, TemplateScript.CONTEXT).newInstance(script.getParams());
        String source = compiledScript.execute();
        response.setSource(new BytesArray(source));
        SearchRequest searchRequest = searchTemplateRequest.getRequest();
        if (searchTemplateRequest.isSimulate()) {
            return null;
        }
        try (XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
            builder.parseXContent(parser, false);
            builder.explain(searchTemplateRequest.isExplain());
            builder.profile(searchTemplateRequest.isProfile());
            searchRequest.source(builder);
        }
        return searchRequest;
    }
}

