/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.support.ValueType;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.sort.SortOrder;
import java.io.IOException;
import java.util.Objects;

public abstract class CompositeValuesSourceBuilder<AB extends CompositeValuesSourceBuilder<AB>>
implements Writeable,
ToXContentFragment {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(CompositeValuesSourceBuilder.class));
    protected final String name;
    private String field = null;
    private Script script = null;
    private ValueType valueType = null;
    private boolean missingBucket = false;
    private Object missing = null;
    private SortOrder order = SortOrder.ASC;
    private String format = null;

    CompositeValuesSourceBuilder(String name) {
        this(name, null);
    }

    CompositeValuesSourceBuilder(String name, ValueType valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    CompositeValuesSourceBuilder(StreamInput in) throws IOException {
        this.name = in.readString();
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.valueType = ValueType.readFromStream(in);
        }
        this.missingBucket = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readBoolean() : false;
        this.missing = in.readGenericValue();
        this.order = SortOrder.readFromStream(in);
        this.format = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readOptionalString() : null;
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.valueType != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.valueType.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeBoolean(this.missingBucket);
        }
        out.writeGenericValue(this.missing);
        this.order.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalString(this.format);
        }
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type());
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        builder.field("missing_bucket", this.missingBucket);
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.getPreferredName());
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        builder.field("order", this.order);
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public final int hashCode() {
        return Objects.hash(this.field, this.missingBucket, this.missing, this.script, this.valueType, this.order, this.format, this.innerHashCode());
    }

    protected abstract int innerHashCode();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeValuesSourceBuilder that = (CompositeValuesSourceBuilder)o;
        return Objects.equals(this.field, that.field()) && Objects.equals(this.script, that.script()) && Objects.equals(this.valueType, that.valueType()) && Objects.equals(this.missingBucket, that.missingBucket()) && Objects.equals(this.missing, that.missing()) && Objects.equals(this.order, that.order()) && Objects.equals(this.format, that.format()) && this.innerEquals(that);
    }

    protected abstract boolean innerEquals(AB var1);

    public String name() {
        return this.name;
    }

    abstract String type();

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    @Deprecated
    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null");
        }
        DEPRECATION_LOGGER.deprecated("[missing] is deprecated. Please use [missing_bucket] instead.", new Object[0]);
        this.missing = missing;
        return (AB)this;
    }

    @Deprecated
    public Object missing() {
        return this.missing;
    }

    public AB missingBucket(boolean missingBucket) {
        this.missingBucket = missingBucket;
        return (AB)this;
    }

    public boolean missingBucket() {
        return this.missingBucket;
    }

    public AB order(String order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = SortOrder.fromString(order);
        return (AB)this;
    }

    public AB order(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = order;
        return (AB)this;
    }

    public SortOrder order() {
        return this.order;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    protected abstract CompositeValuesSourceConfig innerBuild(SearchContext var1, ValuesSourceConfig<?> var2) throws IOException;

    public final CompositeValuesSourceConfig build(SearchContext context) throws IOException {
        ValuesSourceConfig config = ValuesSourceConfig.resolve(context.getQueryShardContext(), this.valueType, this.field, this.script, this.missing, null, this.format);
        if (this.missingBucket && this.missing != null) {
            throw new QueryShardException(context.getQueryShardContext(), "cannot use [missing] option in conjunction with [missing_bucket]", new Object[0]);
        }
        return this.innerBuild(context, config);
    }
}

