/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.dfs;

import conductor.com.carrotsearch.hppc.ObjectObjectHashMap;
import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.common.collect.HppcMaps;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import java.io.IOException;

public class DfsSearchResult
extends SearchPhaseResult {
    private static final Term[] EMPTY_TERMS = new Term[0];
    private static final TermStatistics[] EMPTY_TERM_STATS = new TermStatistics[0];
    private Term[] terms;
    private TermStatistics[] termStatistics;
    private ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
    private int maxDoc;

    public DfsSearchResult() {
    }

    public DfsSearchResult(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public DfsSearchResult(long id, SearchShardTarget shardTarget) {
        this.setSearchShardTarget(shardTarget);
        this.requestId = id;
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsStatistics(Term[] terms, TermStatistics[] termStatistics) {
        this.terms = terms;
        this.termStatistics = termStatistics;
        return this;
    }

    public DfsSearchResult fieldStatistics(ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public TermStatistics[] termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.requestId = in.readLong();
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readString(), in.readBytesRef());
            }
        }
        this.termStatistics = DfsSearchResult.readTermStats(in, this.terms);
        DfsSearchResult.readFieldStats(in, this.fieldStatistics);
        this.maxDoc = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.requestId);
        out.writeVInt(this.terms.length);
        for (Term term : this.terms) {
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
        }
        DfsSearchResult.writeTermStats(out, this.termStatistics);
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVInt(this.maxDoc);
    }

    public static void writeFieldStats(StreamOutput out, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics) throws IOException {
        out.writeVInt(fieldStatistics.size());
        for (ObjectObjectCursor<String, CollectionStatistics> objectObjectCursor : fieldStatistics) {
            out.writeString((String)objectObjectCursor.key);
            CollectionStatistics statistics = (CollectionStatistics)objectObjectCursor.value;
            assert (statistics.maxDoc() >= 0L);
            out.writeVLong(statistics.maxDoc());
            out.writeVLong(DfsSearchResult.addOne(statistics.docCount()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumTotalTermFreq()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumDocFreq()));
        }
    }

    public static void writeTermStats(StreamOutput out, TermStatistics[] termStatistics) throws IOException {
        out.writeVInt(termStatistics.length);
        for (TermStatistics termStatistic : termStatistics) {
            DfsSearchResult.writeSingleTermStats(out, termStatistic);
        }
    }

    public static void writeSingleTermStats(StreamOutput out, TermStatistics termStatistic) throws IOException {
        assert (termStatistic.docFreq() >= 0L);
        out.writeVLong(termStatistic.docFreq());
        out.writeVLong(DfsSearchResult.addOne(termStatistic.totalTermFreq()));
    }

    public static ObjectObjectHashMap<String, CollectionStatistics> readFieldStats(StreamInput in) throws IOException {
        return DfsSearchResult.readFieldStats(in, null);
    }

    public static ObjectObjectHashMap<String, CollectionStatistics> readFieldStats(StreamInput in, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics) throws IOException {
        int numFieldStatistics = in.readVInt();
        if (fieldStatistics == null) {
            fieldStatistics = HppcMaps.newNoNullKeysMap(numFieldStatistics);
        }
        for (int i = 0; i < numFieldStatistics; ++i) {
            String field = in.readString();
            assert (field != null);
            long maxDoc = in.readVLong();
            long docCount = DfsSearchResult.subOne(in.readVLong());
            long sumTotalTermFreq = DfsSearchResult.subOne(in.readVLong());
            long sumDocFreq = DfsSearchResult.subOne(in.readVLong());
            CollectionStatistics stats = new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            fieldStatistics.put(field, stats);
        }
        return fieldStatistics;
    }

    public static TermStatistics[] readTermStats(StreamInput in, Term[] terms) throws IOException {
        TermStatistics[] termStatistics;
        int termsStatsSize = in.readVInt();
        if (termsStatsSize == 0) {
            termStatistics = EMPTY_TERM_STATS;
        } else {
            termStatistics = new TermStatistics[termsStatsSize];
            assert (terms.length == termsStatsSize);
            for (int i = 0; i < termStatistics.length; ++i) {
                BytesRef term = terms[i].bytes();
                long docFreq = in.readVLong();
                assert (docFreq >= 0L);
                long totalTermFreq = DfsSearchResult.subOne(in.readVLong());
                termStatistics[i] = new TermStatistics(term, docFreq, totalTermFreq);
            }
        }
        return termStatistics;
    }

    public static long addOne(long value) {
        assert (value + 1L >= 0L);
        return value + 1L;
    }

    public static long subOne(long value) {
        assert (value >= 0L);
        return value - 1L;
    }
}

