/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.apache.lucene.index.SortedDocValues;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.document.DocumentField;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.ParentFieldMapper;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ParentFieldSubFetchPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        MapperService mapperService = context.mapperService();
        HashSet<String> parentFields = new HashSet<String>();
        for (SearchHit hit : hits) {
            ParentFieldMapper parentFieldMapper = mapperService.documentMapper(hit.getType()).parentFieldMapper();
            if (!parentFieldMapper.active()) continue;
            parentFields.add(parentFieldMapper.name());
        }
        int lastReaderId = -1;
        HashMap<String, SortedDocValues> docValuesMap = new HashMap<String, SortedDocValues>();
        for (SearchHit hit : hits) {
            String value;
            ParentFieldMapper parentFieldMapper = mapperService.documentMapper(hit.getType()).parentFieldMapper();
            if (!parentFieldMapper.active()) continue;
            int readerId = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = context.searcher().getIndexReader().leaves().get(readerId);
            if (lastReaderId != readerId) {
                docValuesMap.clear();
                for (String field : parentFields) {
                    docValuesMap.put(field, subReaderContext.reader().getSortedDocValues(field));
                }
                lastReaderId = readerId;
            }
            int docId = hit.docId() - subReaderContext.docBase;
            SortedDocValues values = (SortedDocValues)docValuesMap.get(parentFieldMapper.name());
            if (values == null || !values.advanceExact(docId)) continue;
            BytesRef binaryValue = values.binaryValue();
            String string = value = binaryValue.length > 0 ? binaryValue.utf8ToString() : null;
            if (value == null) continue;
            Map<String, DocumentField> fields = hit.fieldsOrNull();
            if (fields == null) {
                fields = new HashMap<String, DocumentField>();
                hit.fields(fields);
            }
            fields.put("_parent", new DocumentField("_parent", Collections.singletonList(value)));
        }
    }

    public static String getParentId(ParentFieldMapper fieldMapper, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(fieldMapper.name());
            if (docValues == null || !docValues.advanceExact(docId)) {
                return null;
            }
            BytesRef parentId = docValues.binaryValue();
            return parentId.length > 0 ? parentId.utf8ToString() : null;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

