/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.slice;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.search.MatchAllDocsQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.search.internal.ShardSearchRequest;
import conductor.org.elasticsearch.search.slice.DocValuesSliceQuery;
import conductor.org.elasticsearch.search.slice.TermsSliceQuery;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SliceBuilder
implements Writeable,
ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOG = new DeprecationLogger(LogManager.getLogger(SliceBuilder.class));
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ObjectParser<SliceBuilder, Void> PARSER = new ObjectParser("slice", SliceBuilder::new);
    private String field = "_id";
    private int id = -1;
    private int max = -1;

    private SliceBuilder() {
    }

    public SliceBuilder(int id, int max) {
        this("_id", id, max);
    }

    public SliceBuilder(String field, int id, int max) {
        this.setField(field);
        this.setId(id);
        this.setMax(max);
    }

    public SliceBuilder(StreamInput in) throws IOException {
        String field = in.readString();
        if ("_uid".equals(field) && in.getVersion().before(Version.V_6_3_0)) {
            field = "_id";
        }
        this.field = field;
        this.id = in.readVInt();
        this.max = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if ("_id".equals(this.field) && out.getVersion().before(Version.V_6_3_0)) {
            out.writeString("_uid");
        } else {
            out.writeString(this.field);
        }
        out.writeVInt(this.id);
        out.writeVInt(this.max);
    }

    private SliceBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    private SliceBuilder setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be greater than or equal to 0");
        }
        if (this.max != -1 && id >= this.max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    private SliceBuilder setMax(int max) {
        if (max <= 1) {
            throw new IllegalArgumentException("max must be greater than 1");
        }
        if (this.id != -1 && this.id >= max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(MAX_FIELD.getPreferredName(), this.max);
    }

    public static SliceBuilder fromXContent(XContentParser parser) throws IOException {
        SliceBuilder builder = PARSER.parse(parser, new SliceBuilder(), null);
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SliceBuilder)) {
            return false;
        }
        SliceBuilder o = (SliceBuilder)other;
        return (this.field == null && o.field == null || this.field.equals(o.field)) && this.id == o.id && o.max == this.max;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.id, this.max);
    }

    public Query toFilter(ClusterService clusterService, ShardSearchRequest request, QueryShardContext context, Version minNodeVersion) {
        MappedFieldType type = context.fieldMapper(this.field);
        if (type == null) {
            throw new IllegalArgumentException("field " + this.field + " not found");
        }
        int shardId = request.shardId().id();
        int numShards = context.getIndexSettings().getNumberOfShards();
        if (minNodeVersion.onOrAfter(Version.V_6_4_0) && (request.preference() != null || request.indexRoutings().length > 0)) {
            GroupShardsIterator<ShardIterator> group = this.buildShardIterator(clusterService, request);
            assert (group.size() <= numShards) : "index routing shards: " + group.size() + " cannot be greater than total number of shards: " + numShards;
            if (group.size() < numShards) {
                numShards = group.size();
                int ord = 0;
                shardId = -1;
                for (ShardIterator it : group) {
                    assert (it.shardId().getIndex().equals(request.shardId().getIndex()));
                    if (request.shardId().equals(it.shardId())) {
                        shardId = ord;
                        break;
                    }
                    ++ord;
                }
                assert (shardId != -1) : "shard id: " + request.shardId().getId() + " not found in index shard routing";
            }
        }
        String field = this.field;
        boolean useTermQuery = false;
        if ("_uid".equals(field)) {
            if (context.getIndexSettings().isSingleType()) {
                field = "_id";
                DEPRECATION_LOG.deprecated("Computing slices on the [_uid] field is deprecated for 6.x indices, use [_id] instead", new Object[0]);
            }
            useTermQuery = true;
        } else if ("_id".equals(field)) {
            if (!context.getIndexSettings().isSingleType()) {
                field = "_uid";
            }
            useTermQuery = true;
        } else {
            if (!type.hasDocValues()) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + field);
            }
            Object ifm = context.getForField(type);
            if (!(ifm instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + field);
            }
        }
        if (numShards == 1) {
            return useTermQuery ? new TermsSliceQuery(field, this.id, this.max) : new DocValuesSliceQuery(field, this.id, this.max);
        }
        if (this.max >= numShards) {
            int targetShard = this.id % numShards;
            if (targetShard != shardId) {
                return new MatchNoDocsQuery("this shard is not part of the slice");
            }
            int numSlicesInShard = this.max / numShards;
            int rest = this.max % numShards;
            if (rest > targetShard) {
                ++numSlicesInShard;
            }
            if (numSlicesInShard == 1) {
                return new MatchAllDocsQuery();
            }
            int shardSlice = this.id / numShards;
            return useTermQuery ? new TermsSliceQuery(field, shardSlice, numSlicesInShard) : new DocValuesSliceQuery(field, shardSlice, numSlicesInShard);
        }
        int targetSlice = shardId % this.max;
        if (this.id != targetSlice) {
            return new MatchNoDocsQuery("this shard is not part of the slice");
        }
        return new MatchAllDocsQuery();
    }

    private GroupShardsIterator<ShardIterator> buildShardIterator(ClusterService clusterService, ShardSearchRequest request) {
        ClusterState state = clusterService.state();
        String[] indices = new String[]{request.shardId().getIndex().getName()};
        Map<String, Set<String>> routingMap = request.indexRoutings().length > 0 ? Collections.singletonMap(indices[0], Sets.newHashSet(request.indexRoutings())) : null;
        return clusterService.operationRouting().searchShards(state, indices, routingMap, request.preference());
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareString(SliceBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(SliceBuilder::setId, ID_FIELD);
        PARSER.declareInt(SliceBuilder::setMax, MAX_FIELD);
    }
}

