/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.processors;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import conductor.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import conductor.org.apache.lucene.queryparser.flexible.standard.nodes.RegexpQueryNode;
import java.util.List;

public class RegexpQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof RegexpQueryNode) {
            RegexpQueryNode regexpNode = (RegexpQueryNode)node;
            Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
            if (analyzer != null) {
                String text = regexpNode.getText().toString();
                text = analyzer.normalize(regexpNode.getFieldAsString(), text).utf8ToString();
                regexpNode.setText(text);
            }
        }
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

