/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.xml.builders;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.queryparser.xml.DOMUtils;
import conductor.org.apache.lucene.queryparser.xml.ParserException;
import conductor.org.apache.lucene.queryparser.xml.QueryBuilder;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.BoostQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import org.w3c.dom.Element;

public class TermsQueryBuilder
implements QueryBuilder {
    private final Analyzer analyzer;

    public TermsQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String text = DOMUtils.getNonBlankTextOrFail(e);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setMinimumNumberShouldMatch(DOMUtils.getAttribute(e, "minimumNumberShouldMatch", 0));
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, text);){
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            Term term = null;
            ts.reset();
            while (ts.incrementToken()) {
                term = new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef()));
                bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
            }
            ts.end();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error constructing terms from index:" + ioe);
        }
        BooleanQuery q = bq.build();
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new BoostQuery(q, boost);
    }
}

