/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.fst;

import conductor.org.apache.lucene.codecs.CodecUtil;
import conductor.org.apache.lucene.search.suggest.InputIterator;
import conductor.org.apache.lucene.search.suggest.Lookup;
import conductor.org.apache.lucene.search.suggest.fst.ExternalRefSorter;
import conductor.org.apache.lucene.search.suggest.fst.FSTCompletion;
import conductor.org.apache.lucene.search.suggest.fst.FSTCompletionBuilder;
import conductor.org.apache.lucene.store.ByteArrayDataInput;
import conductor.org.apache.lucene.store.ByteArrayDataOutput;
import conductor.org.apache.lucene.store.DataInput;
import conductor.org.apache.lucene.store.DataOutput;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.IOContext;
import conductor.org.apache.lucene.store.IndexOutput;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.Accountables;
import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.apache.lucene.util.IOUtils;
import conductor.org.apache.lucene.util.OfflineSorter;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import conductor.org.apache.lucene.util.fst.FST;
import conductor.org.apache.lucene.util.fst.NoOutputs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class FSTCompletionLookup
extends Lookup
implements Accountable {
    private static int INVALID_BUCKETS_COUNT = -1;
    private static final int sharedTailLength = 5;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    private int buckets;
    private boolean exactMatchFirst;
    private FSTCompletion higherWeightsCompletion;
    private FSTCompletion normalCompletion;
    private long count = 0L;

    public FSTCompletionLookup() {
        this(null, null);
    }

    public FSTCompletionLookup(Directory tempDir, String tempFileNamePrefix) {
        this(tempDir, tempFileNamePrefix, 10, true);
    }

    public FSTCompletionLookup(Directory tempDir, String tempFileNamePrefix, int buckets, boolean exactMatchFirst) {
        this.buckets = buckets;
        this.exactMatchFirst = exactMatchFirst;
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    public FSTCompletionLookup(Directory tempDir, String tempFileNamePrefix, FSTCompletion completion, boolean exactMatchFirst) {
        this(tempDir, tempFileNamePrefix, INVALID_BUCKETS_COUNT, exactMatchFirst);
        this.normalCompletion = new FSTCompletion(completion.getFST(), false, exactMatchFirst);
        this.higherWeightsCompletion = new FSTCompletion(completion.getFST(), true, exactMatchFirst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iterator) throws IOException {
        if (iterator.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (iterator.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        OfflineSorter sorter = new OfflineSorter(this.tempDir, this.tempFileNamePrefix);
        ExternalRefSorter externalSorter = new ExternalRefSorter(sorter);
        IndexOutput tempInput = this.tempDir.createTempOutput(this.tempFileNamePrefix, "input", IOContext.DEFAULT);
        String tempSortedFileName = null;
        OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(tempInput);
        OfflineSorter.ByteSequencesReader reader = null;
        this.count = 0L;
        try {
            BytesRef scratch;
            BytesRef spare;
            byte[] buffer = new byte[]{};
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            int inputLineCount = 0;
            while ((spare = iterator.next()) != null) {
                if (spare.length + 4 >= buffer.length) {
                    buffer = ArrayUtil.grow(buffer, spare.length + 4);
                }
                output.reset(buffer);
                output.writeInt(FSTCompletionLookup.encodeWeight(iterator.weight()));
                output.writeBytes(spare.bytes, spare.offset, spare.length);
                writer.write(buffer, 0, output.getPosition());
                ++inputLineCount;
            }
            CodecUtil.writeFooter(tempInput);
            writer.close();
            tempSortedFileName = sorter.sort(tempInput.getName());
            this.tempDir.deleteFile(tempInput.getName());
            FSTCompletionBuilder builder = new FSTCompletionBuilder(this.buckets, externalSorter, 5);
            reader = new OfflineSorter.ByteSequencesReader(this.tempDir.openChecksumInput(tempSortedFileName, IOContext.READONCE), tempSortedFileName);
            long line = 0L;
            int previousBucket = 0;
            int previousScore = 0;
            ByteArrayDataInput input = new ByteArrayDataInput();
            BytesRef tmp2 = new BytesRef();
            while ((scratch = reader.next()) != null) {
                input.reset(scratch.bytes, scratch.offset, scratch.length);
                int currentScore = input.readInt();
                int bucket = line > 0L && currentScore == previousScore ? previousBucket : (int)(line * (long)this.buckets / (long)inputLineCount);
                previousScore = currentScore;
                previousBucket = bucket;
                tmp2.bytes = scratch.bytes;
                tmp2.offset = scratch.offset + input.getPosition();
                tmp2.length = scratch.length - input.getPosition();
                builder.add(tmp2, bucket);
                ++line;
                ++this.count;
            }
            this.higherWeightsCompletion = builder.build();
            this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(reader, writer, externalSorter);
            IOUtils.deleteFilesIgnoringExceptions(this.tempDir, tempInput.getName(), tempSortedFileName);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(reader, writer, externalSorter);
        IOUtils.deleteFilesIgnoringExceptions(this.tempDir, tempInput.getName(), tempSortedFileName);
    }

    private static int encodeWeight(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return (int)value;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean higherWeightsFirst, int num) {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        List<FSTCompletion.Completion> completions = higherWeightsFirst ? this.higherWeightsCompletion.lookup(key, num) : this.normalCompletion.lookup(key, num);
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(completions.size());
        CharsRefBuilder spare = new CharsRefBuilder();
        for (FSTCompletion.Completion c : completions) {
            spare.copyUTF8Bytes(c.utf8);
            results.add(new Lookup.LookupResult(spare.toString(), c.bucket));
        }
        return results;
    }

    public Object get(CharSequence key) {
        int bucket = this.normalCompletion.getBucket(key);
        return bucket == -1 ? null : Long.valueOf(bucket);
    }

    @Override
    public synchronized boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.normalCompletion == null || this.normalCompletion.getFST() == null) {
            return false;
        }
        this.normalCompletion.getFST().save(output);
        return true;
    }

    @Override
    public synchronized boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.higherWeightsCompletion = new FSTCompletion(new FST<Object>(input, NoOutputs.getSingleton()));
        this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
        return true;
    }

    @Override
    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf(this) + RamUsageEstimator.shallowSizeOf(this.normalCompletion) + RamUsageEstimator.shallowSizeOf(this.higherWeightsCompletion);
        if (this.normalCompletion != null) {
            mem += this.normalCompletion.getFST().ramBytesUsed();
        }
        if (this.higherWeightsCompletion != null && (this.normalCompletion == null || this.normalCompletion.getFST() != this.higherWeightsCompletion.getFST())) {
            mem += this.higherWeightsCompletion.getFST().ramBytesUsed();
        }
        return mem;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        if (this.normalCompletion != null) {
            resources.add(Accountables.namedAccountable("fst", this.normalCompletion.getFST()));
        }
        if (this.higherWeightsCompletion != null && (this.normalCompletion == null || this.normalCompletion.getFST() != this.higherWeightsCompletion.getFST())) {
            resources.add(Accountables.namedAccountable("higher weights fst", this.higherWeightsCompletion.getFST()));
        }
        return Collections.unmodifiableList(resources);
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

