/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.ClearScrollController;
import conductor.org.elasticsearch.action.search.ClearScrollRequest;
import conductor.org.elasticsearch.action.search.ClearScrollResponse;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportClearScrollAction
extends HandledTransportAction<ClearScrollRequest, ClearScrollResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;

    @Inject
    public TransportClearScrollAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SearchTransportService searchTransportService) {
        super(settings, "indices:data/read/scroll/clear", threadPool, transportService, actionFilters, indexNameExpressionResolver, ClearScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
    }

    @Override
    protected void doExecute(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        ClearScrollController runnable = new ClearScrollController(request, listener, this.clusterService.state().nodes(), this.logger, this.searchTransportService);
        runnable.run();
    }
}

