/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ShardOperationFailedException;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;

public class DefaultShardOperationFailedException
extends ShardOperationFailedException {
    private static final String INDEX = "index";
    private static final String SHARD_ID = "shard";
    private static final String REASON = "reason";
    public static final ConstructingObjectParser<DefaultShardOperationFailedException, Void> PARSER = new ConstructingObjectParser("failures", true, arg -> new DefaultShardOperationFailedException((String)arg[0], (Integer)arg[1], (Throwable)arg[2]));

    protected DefaultShardOperationFailedException() {
    }

    public DefaultShardOperationFailedException(ElasticsearchException e) {
        super(e.getIndex() == null ? null : e.getIndex().getName(), e.getShardId() == null ? -1 : e.getShardId().getId(), ExceptionsHelper.detailedMessage(e), e.status(), e);
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable cause) {
        super(index, shardId, ExceptionsHelper.detailedMessage(cause), ExceptionsHelper.status(cause), cause);
    }

    public static DefaultShardOperationFailedException readShardOperationFailed(StreamInput in) throws IOException {
        DefaultShardOperationFailedException exp = new DefaultShardOperationFailedException();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readOptionalString();
        this.shardId = in.readVInt();
        this.cause = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.index);
        out.writeVInt(this.shardId);
        out.writeException(this.cause);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARD_ID, this.shardId());
        builder.field(INDEX, this.index());
        builder.field("status", this.status.name());
        if (this.reason != null) {
            builder.startObject(REASON);
            ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
        }
        return builder;
    }

    public static DefaultShardOperationFailedException fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_ID, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField(REASON, new String[0]));
    }
}

