/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.WatcherRequestConverters;
import conductor.org.elasticsearch.client.watcher.AckWatchRequest;
import conductor.org.elasticsearch.client.watcher.AckWatchResponse;
import conductor.org.elasticsearch.client.watcher.ActivateWatchRequest;
import conductor.org.elasticsearch.client.watcher.ActivateWatchResponse;
import conductor.org.elasticsearch.client.watcher.DeactivateWatchRequest;
import conductor.org.elasticsearch.client.watcher.DeactivateWatchResponse;
import conductor.org.elasticsearch.client.watcher.DeleteWatchRequest;
import conductor.org.elasticsearch.client.watcher.DeleteWatchResponse;
import conductor.org.elasticsearch.client.watcher.ExecuteWatchRequest;
import conductor.org.elasticsearch.client.watcher.ExecuteWatchResponse;
import conductor.org.elasticsearch.client.watcher.GetWatchRequest;
import conductor.org.elasticsearch.client.watcher.GetWatchResponse;
import conductor.org.elasticsearch.client.watcher.PutWatchRequest;
import conductor.org.elasticsearch.client.watcher.PutWatchResponse;
import conductor.org.elasticsearch.client.watcher.StartWatchServiceRequest;
import conductor.org.elasticsearch.client.watcher.StopWatchServiceRequest;
import conductor.org.elasticsearch.client.watcher.WatcherStatsRequest;
import conductor.org.elasticsearch.client.watcher.WatcherStatsResponse;
import java.io.IOException;
import java.util.Collections;

public final class WatcherClient {
    private final RestHighLevelClient restHighLevelClient;

    WatcherClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse startWatchService(StartWatchServiceRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::startWatchService, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void startWatchServiceAsync(StartWatchServiceRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::startWatchService, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse stopWatchService(StopWatchServiceRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::stopWatchService, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void stopWatchServiceAsync(StopWatchServiceRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::stopWatchService, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutWatchResponse putWatch(PutWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::putWatch, options, PutWatchResponse::fromXContent, Collections.emptySet());
    }

    public void putWatchAsync(PutWatchRequest request, RequestOptions options, ActionListener<PutWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::putWatch, options, PutWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetWatchResponse getWatch(GetWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::getWatch, options, GetWatchResponse::fromXContent, Collections.emptySet());
    }

    public void getWatchAsync(GetWatchRequest request, RequestOptions options, ActionListener<GetWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::getWatch, options, GetWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeactivateWatchResponse deactivateWatch(DeactivateWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::deactivateWatch, options, DeactivateWatchResponse::fromXContent, Collections.emptySet());
    }

    public void deactivateWatchAsync(DeactivateWatchRequest request, RequestOptions options, ActionListener<DeactivateWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::deactivateWatch, options, DeactivateWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteWatchResponse deleteWatch(DeleteWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::deleteWatch, options, DeleteWatchResponse::fromXContent, Collections.singleton(404));
    }

    public void deleteWatchAsync(DeleteWatchRequest request, RequestOptions options, ActionListener<DeleteWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::deleteWatch, options, DeleteWatchResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AckWatchResponse ackWatch(AckWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::ackWatch, options, AckWatchResponse::fromXContent, Collections.emptySet());
    }

    public void ackWatchAsync(AckWatchRequest request, RequestOptions options, ActionListener<AckWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::ackWatch, options, AckWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public ActivateWatchResponse activateWatch(ActivateWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::activateWatch, options, ActivateWatchResponse::fromXContent, Collections.singleton(404));
    }

    public void activateWatchAsync(ActivateWatchRequest request, RequestOptions options, ActionListener<ActivateWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::activateWatch, options, ActivateWatchResponse::fromXContent, listener, Collections.singleton(404));
    }

    public ExecuteWatchResponse executeWatch(ExecuteWatchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::executeWatch, options, ExecuteWatchResponse::fromXContent, Collections.emptySet());
    }

    public void executeWatchAsync(ExecuteWatchRequest request, RequestOptions options, ActionListener<ExecuteWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::executeWatch, options, ExecuteWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public WatcherStatsResponse watcherStats(WatcherStatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::watcherStats, options, WatcherStatsResponse::fromXContent, Collections.emptySet());
    }

    public void watcherStatsAsync(WatcherStatsRequest request, RequestOptions options, ActionListener<WatcherStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::watcherStats, options, WatcherStatsResponse::fromXContent, listener, Collections.emptySet());
    }
}

