/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indexlifecycle;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.client.indexlifecycle.LifecyclePolicyMetadata;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class GetLifecyclePolicyResponse
implements ToXContentObject {
    private final ImmutableOpenMap<String, LifecyclePolicyMetadata> policies;

    public GetLifecyclePolicyResponse(ImmutableOpenMap<String, LifecyclePolicyMetadata> policies) {
        this.policies = policies;
    }

    public ImmutableOpenMap<String, LifecyclePolicyMetadata> getPolicies() {
        return this.policies;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ObjectObjectCursor<String, LifecyclePolicyMetadata> objectObjectCursor : this.policies) {
            builder.field((String)objectObjectCursor.key, (ToXContent)objectObjectCursor.value);
        }
        builder.endObject();
        return builder;
    }

    public static GetLifecyclePolicyResponse fromXContent(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder<String, LifecyclePolicyMetadata> policies = ImmutableOpenMap.builder();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String policyName = parser.currentName();
                LifecyclePolicyMetadata policyDefinion = LifecyclePolicyMetadata.parse(parser, policyName);
                policies.put(policyName, policyDefinion);
                continue;
            }
            parser.nextToken();
        }
        return new GetLifecyclePolicyResponse(policies.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetLifecyclePolicyResponse that = (GetLifecyclePolicyResponse)o;
        return Objects.equals(this.getPolicies(), that.getPolicies());
    }

    public int hashCode() {
        return Objects.hash(this.getPolicies());
    }
}

