/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indexlifecycle;

import conductor.org.elasticsearch.client.indexlifecycle.Phase;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class PhaseExecutionInfo
implements ToXContentObject {
    private static final ParseField POLICY_NAME_FIELD = new ParseField("policy", new String[0]);
    private static final ParseField PHASE_DEFINITION_FIELD = new ParseField("phase_definition", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField MODIFIED_DATE_IN_MILLIS_FIELD = new ParseField("modified_date_in_millis", new String[0]);
    private static final ConstructingObjectParser<PhaseExecutionInfo, String> PARSER = new ConstructingObjectParser<PhaseExecutionInfo, String>("phase_execution_info", true, (a, name) -> new PhaseExecutionInfo((String)a[0], (Phase)a[1], (Long)a[2], (Long)a[3]));
    private final String policyName;
    private final Phase phase;
    private final long version;
    private final long modifiedDate;

    public static PhaseExecutionInfo parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public PhaseExecutionInfo(String policyName, Phase phase, long version, long modifiedDate) {
        this.policyName = policyName;
        this.phase = phase;
        this.version = version;
        this.modifiedDate = modifiedDate;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public int hashCode() {
        return Objects.hash(this.policyName, this.phase, this.version, this.modifiedDate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseExecutionInfo other = (PhaseExecutionInfo)obj;
        return Objects.equals(this.policyName, other.policyName) && Objects.equals(this.phase, other.phase) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate);
    }

    public String toString() {
        return Strings.toString(this, false, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_NAME_FIELD.getPreferredName(), this.policyName);
        if (this.phase != null) {
            builder.field(PHASE_DEFINITION_FIELD.getPreferredName(), this.phase);
        }
        builder.field(VERSION_FIELD.getPreferredName(), this.version);
        builder.timeField(MODIFIED_DATE_IN_MILLIS_FIELD.getPreferredName(), "modified_date", this.modifiedDate);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Phase::parse, PHASE_DEFINITION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_IN_MILLIS_FIELD);
    }
}

