/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.rollup;

import conductor.org.elasticsearch.client.rollup.RollupJobCaps;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RollableIndexCaps
implements ToXContentFragment {
    private static final ParseField ROLLUP_JOBS = new ParseField("rollup_jobs", new String[0]);
    public static final Function<String, ConstructingObjectParser<RollableIndexCaps, Void>> PARSER = indexName -> {
        ConstructingObjectParser<RollableIndexCaps, Void> p = new ConstructingObjectParser<RollableIndexCaps, Void>((String)indexName, true, a -> new RollableIndexCaps((String)indexName, (List)a[0]));
        p.declareObjectArray(ConstructingObjectParser.constructorArg(), RollupJobCaps.PARSER::apply, ROLLUP_JOBS);
        return p;
    };
    private final String indexName;
    private final List<RollupJobCaps> jobCaps;

    RollableIndexCaps(String indexName, List<RollupJobCaps> caps) {
        this.indexName = indexName;
        this.jobCaps = Collections.unmodifiableList(Objects.requireNonNull(caps).stream().sorted(Comparator.comparing(RollupJobCaps::getJobID)).collect(Collectors.toList()));
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<RollupJobCaps> getJobCaps() {
        return this.jobCaps;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.indexName);
        builder.field(ROLLUP_JOBS.getPreferredName(), this.jobCaps);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollableIndexCaps that = (RollableIndexCaps)other;
        return Objects.equals(this.jobCaps, that.jobCaps) && Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.jobCaps, this.indexName);
    }
}

