/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.Diff;
import conductor.org.elasticsearch.cluster.Diffable;
import conductor.org.elasticsearch.cluster.NamedDiff;
import conductor.org.elasticsearch.cluster.NamedDiffable;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.NamedWriteable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public abstract class AbstractNamedDiffable<T extends NamedDiffable<T>>
implements Diffable<T>,
NamedWriteable {
    @Override
    public Diff<T> diff(T previousState) {
        if (this.get().equals(previousState)) {
            return new CompleteNamedDiff(previousState.getWriteableName(), previousState.getMinimalSupportedVersion());
        }
        return new CompleteNamedDiff<T>(this.get());
    }

    public static <T extends NamedDiffable<T>> NamedDiff<T> readDiffFrom(Class<? extends T> tClass, String name, StreamInput in) throws IOException {
        return new CompleteNamedDiff<T>(tClass, name, in);
    }

    public T get() {
        return (T)((NamedDiffable)((Object)this));
    }

    private static class CompleteNamedDiff<T extends NamedDiffable<T>>
    implements NamedDiff<T> {
        @Nullable
        private final T part;
        private final String name;
        @Nullable
        private final Version minimalSupportedVersion;

        CompleteNamedDiff(T part) {
            this.part = part;
            this.name = part.getWriteableName();
            this.minimalSupportedVersion = part.getMinimalSupportedVersion();
        }

        CompleteNamedDiff(String name, Version minimalSupportedVersion) {
            this.part = null;
            this.name = name;
            this.minimalSupportedVersion = minimalSupportedVersion;
        }

        CompleteNamedDiff(Class<? extends T> tClass, String name, StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.part = (NamedDiffable)in.readNamedWriteable(tClass, name);
                this.minimalSupportedVersion = this.part.getMinimalSupportedVersion();
            } else {
                this.part = null;
                this.minimalSupportedVersion = null;
            }
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (this.minimalSupportedVersion != null) : "shouldn't be called on diff that was de-serialized from the stream";
            if (this.part != null) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public T apply(T part) {
            if (this.part != null) {
                return this.part;
            }
            return part;
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public Version getMinimalSupportedVersion() {
            assert (this.minimalSupportedVersion != null) : "shouldn't be called on the diff that was de-serialized from the stream";
            return this.minimalSupportedVersion;
        }
    }
}

