/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import conductor.org.elasticsearch.common.collect.CopyOnWriteHashMap;
import java.util.Map;

public final class FieldNameAnalyzer
extends DelegatingAnalyzerWrapper {
    private final Map<String, Analyzer> analyzers;

    public FieldNameAnalyzer(Map<String, Analyzer> analyzers) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.analyzers = CopyOnWriteHashMap.copyOf(analyzers);
    }

    public Map<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.analyzers.get(fieldName);
        if (analyzer != null) {
            return analyzer;
        }
        throw new IllegalArgumentException("Field [" + fieldName + "] has no associated analyzer");
    }
}

