/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.engine;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.FieldInfos;
import conductor.org.apache.lucene.index.Fields;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafMetaData;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.index.SortedDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.index.StoredFieldVisitor;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import conductor.org.elasticsearch.index.mapper.Uid;
import conductor.org.elasticsearch.index.translog.Translog;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

final class TranslogLeafReader
extends LeafReader {
    private final Translog.Index operation;
    private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private static final FieldInfo FAKE_UID_FIELD = new FieldInfo("_uid", 4, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private final Version indexVersionCreated;

    TranslogLeafReader(Translog.Index operation, Version indexVersionCreated) {
        this.operation = operation;
        this.indexVersionCreated = indexVersionCreated;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Terms terms(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) {
        if (field.startsWith("_parent#") && this.operation.parent() != null) {
            return new AbstractSortedDocValues(){
                private final BytesRef term;
                private int ord;
                {
                    this.term = new BytesRef(TranslogLeafReader.this.operation.parent());
                }

                @Override
                public int docID() {
                    return 0;
                }

                @Override
                public boolean advanceExact(int docID) {
                    if (docID != 0) {
                        throw new IndexOutOfBoundsException("do such doc ID: " + docID);
                    }
                    this.ord = 0;
                    return true;
                }

                @Override
                public int ordValue() {
                    return this.ord;
                }

                @Override
                public BytesRef lookupOrd(int ord) {
                    if (ord == 0) {
                        return this.term;
                    }
                    return null;
                }

                @Override
                public int getValueCount() {
                    return 1;
                }
            };
        }
        if (this.operation.parent() == null) {
            return null;
        }
        assert (false) : "unexpected field: " + field;
        return null;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericDocValues getNormValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointValues getPointValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkIntegrity() {
    }

    @Override
    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Fields getTermVectors(int docID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numDocs() {
        return 1;
    }

    @Override
    public int maxDoc() {
        return 1;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        if (docID != 0) {
            throw new IllegalArgumentException("no such doc ID " + docID);
        }
        if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
            assert (this.operation.source().toBytesRef().offset == 0);
            assert (this.operation.source().toBytesRef().length == this.operation.source().toBytesRef().bytes.length);
            visitor.binaryField(FAKE_SOURCE_FIELD, this.operation.source().toBytesRef().bytes);
        }
        if (this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
            visitor.stringField(FAKE_ROUTING_FIELD, this.operation.routing().getBytes(StandardCharsets.UTF_8));
        }
        if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
            byte[] id;
            if (this.indexVersionCreated.onOrAfter(Version.V_6_0_0)) {
                BytesRef bytesRef = Uid.encodeId(this.operation.id());
                id = new byte[bytesRef.length];
                System.arraycopy(bytesRef.bytes, bytesRef.offset, id, 0, bytesRef.length);
            } else {
                id = this.operation.id().getBytes(StandardCharsets.UTF_8);
            }
            visitor.stringField(FAKE_ID_FIELD, id);
        }
        if (visitor.needsField(FAKE_UID_FIELD) == StoredFieldVisitor.Status.YES) {
            visitor.stringField(FAKE_UID_FIELD, Uid.createUid(this.operation.type(), this.operation.id()).getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }
}

