/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.query;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.MatchAllDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.lucene.search.Queries;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.InnerHitContextBuilder;
import conductor.org.elasticsearch.index.query.MatchAllQueryBuilder;
import conductor.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class BoolQueryBuilder
extends AbstractQueryBuilder<BoolQueryBuilder> {
    public static final String NAME = "bool";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(BoolQueryBuilder.class));
    public static final boolean ADJUST_PURE_NEGATIVE_DEFAULT = true;
    private static final String MUSTNOT = "mustNot";
    private static final String MUST_NOT = "must_not";
    private static final String FILTER = "filter";
    private static final String SHOULD = "should";
    private static final String MUST = "must";
    private static final ParseField DISABLE_COORD_FIELD = new ParseField("disable_coord", new String[0]).withAllDeprecated("disable_coord has been removed");
    private static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField ADJUST_PURE_NEGATIVE = new ParseField("adjust_pure_negative", new String[0]);
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
    private boolean adjustPureNegative = true;
    private String minimumShouldMatch;

    public BoolQueryBuilder() {
    }

    public BoolQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.mustClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.mustNotClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.shouldClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.filterClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.adjustPureNegative = in.readBoolean();
        if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
            in.readBoolean();
        }
        this.minimumShouldMatch = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        BoolQueryBuilder.writeQueries(out, this.mustClauses);
        BoolQueryBuilder.writeQueries(out, this.mustNotClauses);
        BoolQueryBuilder.writeQueries(out, this.shouldClauses);
        BoolQueryBuilder.writeQueries(out, this.filterClauses);
        out.writeBoolean(this.adjustPureNegative);
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeBoolean(true);
        }
        out.writeOptionalString(this.minimumShouldMatch);
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> must() {
        return this.mustClauses;
    }

    public BoolQueryBuilder filter(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.filterClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> filter() {
        return this.filterClauses;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustNotClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> mustNot() {
        return this.mustNotClauses;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.shouldClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> should() {
        return this.shouldClauses;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public BoolQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public BoolQueryBuilder minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = Integer.toString(minimumShouldMatch);
        return this;
    }

    public boolean hasClauses() {
        return !this.mustClauses.isEmpty() || !this.shouldClauses.isEmpty() || !this.mustNotClauses.isEmpty() || !this.filterClauses.isEmpty();
    }

    public BoolQueryBuilder adjustPureNegative(boolean adjustPureNegative) {
        this.adjustPureNegative = adjustPureNegative;
        return this;
    }

    public boolean adjustPureNegative() {
        return this.adjustPureNegative;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        BoolQueryBuilder.doXArrayContent(MUST, this.mustClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(FILTER, this.filterClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(MUST_NOT, this.mustNotClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(SHOULD, this.shouldClauses, builder, params);
        builder.field(ADJUST_PURE_NEGATIVE.getPreferredName(), this.adjustPureNegative);
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static void doXArrayContent(String field, List<QueryBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        builder.startArray(field);
        for (QueryBuilder clause : clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
    }

    public static BoolQueryBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        boolean adjustPureNegative = true;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        ArrayList<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
        String queryName = null;
        String currentFieldName = null;
        block26: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                switch (currentFieldName) {
                    case "must": {
                        mustClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                        continue block26;
                    }
                    case "should": {
                        shouldClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                        continue block26;
                    }
                    case "filter": {
                        filterClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                        continue block26;
                    }
                    case "must_not": 
                    case "mustNot": {
                        mustNotClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                        continue block26;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                block27: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    switch (currentFieldName) {
                        case "must": {
                            mustClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                            continue block27;
                        }
                        case "should": {
                            shouldClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                            continue block27;
                        }
                        case "filter": {
                            filterClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                            continue block27;
                        }
                        case "must_not": 
                        case "mustNot": {
                            mustNotClauses.add(BoolQueryBuilder.parseInnerQueryBuilder(parser));
                            continue block27;
                        }
                    }
                    throw new ParsingException(parser.getTokenLocation(), "bool query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue() || DISABLE_COORD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
            if (MINIMUM_SHOULD_MATCH.match(currentFieldName, parser.getDeprecationHandler())) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if (BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (ADJUST_PURE_NEGATIVE.match(currentFieldName, parser.getDeprecationHandler())) {
                adjustPureNegative = parser.booleanValue();
                continue;
            }
            if (NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        for (QueryBuilder queryBuilder : mustClauses) {
            boolQuery.must(queryBuilder);
        }
        for (QueryBuilder queryBuilder : mustNotClauses) {
            boolQuery.mustNot(queryBuilder);
        }
        for (QueryBuilder queryBuilder : shouldClauses) {
            boolQuery.should(queryBuilder);
        }
        for (QueryBuilder queryBuilder : filterClauses) {
            boolQuery.filter(queryBuilder);
        }
        boolQuery.boost(boost);
        boolQuery.adjustPureNegative(adjustPureNegative);
        boolQuery.minimumShouldMatch(minimumShouldMatch);
        boolQuery.queryName(queryName);
        return boolQuery;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        String minimumShouldMatch;
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustClauses, BooleanClause.Occur.MUST);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustNotClauses, BooleanClause.Occur.MUST_NOT);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.shouldClauses, BooleanClause.Occur.SHOULD);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.filterClauses, BooleanClause.Occur.FILTER);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        if (booleanQuery.clauses().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        if (context.isFilter() && this.minimumShouldMatch == null && this.shouldClauses.size() > 0) {
            if (this.mustClauses.size() > 0 || this.mustNotClauses.size() > 0 || this.filterClauses.size() > 0) {
                deprecationLogger.deprecatedAndMaybeLog("filter_context_min_should_match", "Should clauses in the filter context will no longer automatically set the minimum should match to 1 in the next major version. You should group them in a [filter] clause or explicitly set [minimum_should_match] to 1 to restore this behavior in the next major version.", new Object[0]);
            }
            minimumShouldMatch = "1";
        } else {
            minimumShouldMatch = this.minimumShouldMatch;
        }
        Query query = Queries.applyMinimumShouldMatch(booleanQuery, minimumShouldMatch);
        return this.adjustPureNegative ? Queries.fixNegativeQueryIfNeeded(query) : query;
    }

    private static void addBooleanClauses(QueryShardContext context, BooleanQuery.Builder booleanQueryBuilder, List<QueryBuilder> clauses, BooleanClause.Occur occurs) throws IOException {
        for (QueryBuilder query : clauses) {
            Query luceneQuery = null;
            switch (occurs) {
                case MUST: 
                case SHOULD: {
                    luceneQuery = query.toQuery(context);
                    break;
                }
                case FILTER: 
                case MUST_NOT: {
                    luceneQuery = query.toFilter(context);
                }
            }
            booleanQueryBuilder.add(new BooleanClause(luceneQuery, occurs));
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.adjustPureNegative, this.minimumShouldMatch, this.mustClauses, this.shouldClauses, this.mustNotClauses, this.filterClauses);
    }

    @Override
    protected boolean doEquals(BoolQueryBuilder other) {
        return Objects.equals(this.adjustPureNegative, other.adjustPureNegative) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.mustClauses, other.mustClauses) && Objects.equals(this.shouldClauses, other.shouldClauses) && Objects.equals(this.mustNotClauses, other.mustNotClauses) && Objects.equals(this.filterClauses, other.filterClauses);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        BoolQueryBuilder newBuilder = new BoolQueryBuilder();
        boolean changed = false;
        int clauses = this.mustClauses.size() + this.mustNotClauses.size() + this.filterClauses.size() + this.shouldClauses.size();
        if (clauses == 0) {
            return ((MatchAllQueryBuilder)new MatchAllQueryBuilder().boost(this.boost())).queryName(this.queryName());
        }
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustClauses, newBuilder::must);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustNotClauses, newBuilder::mustNot);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.filterClauses, newBuilder::filter);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.shouldClauses, newBuilder::should);
        Optional<QueryBuilder> any = Stream.concat(newBuilder.mustClauses.stream(), newBuilder.filterClauses.stream()).filter((? super T b) -> b instanceof MatchNoneQueryBuilder).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        if (changed) {
            newBuilder.adjustPureNegative = this.adjustPureNegative;
            newBuilder.minimumShouldMatch = this.minimumShouldMatch;
            newBuilder.boost(this.boost());
            newBuilder.queryName(this.queryName());
            return newBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        ArrayList<QueryBuilder> clauses = new ArrayList<QueryBuilder>(this.filter());
        clauses.addAll(this.must());
        clauses.addAll(this.should());
        for (QueryBuilder clause : clauses) {
            InnerHitContextBuilder.extractInnerHits(clause, innerHits);
        }
    }

    private static boolean rewriteClauses(QueryRewriteContext queryRewriteContext, List<QueryBuilder> builders, Consumer<QueryBuilder> consumer) throws IOException {
        boolean changed = false;
        for (QueryBuilder builder : builders) {
            QueryBuilder result = builder.rewrite(queryRewriteContext);
            if (result != builder) {
                changed = true;
            }
            consumer.accept(result);
        }
        return changed;
    }
}

