/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.sort.SortOrder;

class CompositeValuesSourceConfig {
    private final String name;
    @Nullable
    private final MappedFieldType fieldType;
    private final ValuesSource vs;
    private final DocValueFormat format;
    private final int reverseMul;
    private final Object missing;
    private final boolean missingBucket;

    CompositeValuesSourceConfig(String name, @Nullable MappedFieldType fieldType, ValuesSource vs, DocValueFormat format, SortOrder order, boolean missingBucket, @Nullable Object missing) {
        this.name = name;
        this.fieldType = fieldType;
        this.vs = vs;
        this.format = format;
        this.reverseMul = order == SortOrder.ASC ? 1 : -1;
        this.missingBucket = missingBucket;
        assert (!missingBucket || missing == null);
        this.missing = missing;
    }

    String name() {
        return this.name;
    }

    MappedFieldType fieldType() {
        return this.fieldType;
    }

    ValuesSource valuesSource() {
        return this.vs;
    }

    DocValueFormat format() {
        return this.format;
    }

    Object missing() {
        return this.missing;
    }

    boolean missingBucket() {
        return this.missingBucket;
    }

    int reverseMul() {
        assert (this.reverseMul == -1 || this.reverseMul == 1);
        return this.reverseMul;
    }
}

