/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.range;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import conductor.org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.range.RangeAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Map;

public class RangeAggregationBuilder
extends AbstractRangeBuilder<RangeAggregationBuilder, RangeAggregator.Range> {
    public static final String NAME = "range";
    private static final ObjectParser<RangeAggregationBuilder, Void> PARSER = new ObjectParser("range");

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new RangeAggregationBuilder(aggregationName), null);
    }

    private static RangeAggregator.Range parseRange(XContentParser parser) throws IOException {
        return RangeAggregator.Range.fromXContent(parser);
    }

    public RangeAggregationBuilder(String name) {
        super(name, InternalRange.FACTORY);
    }

    public RangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalRange.FACTORY, RangeAggregator.Range::new);
    }

    protected RangeAggregationBuilder(RangeAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new RangeAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public RangeAggregationBuilder addRange(String key, double from, double to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public RangeAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public RangeAggregationBuilder addUnboundedTo(String key, double to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public RangeAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public RangeAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public RangeAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    protected RangeAggregatorFactory innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RangeAggregator.Range[] ranges = this.processRanges(range -> {
            DocValueFormat parser = config.format();
            assert (parser != null);
            Double from = range.from;
            Double to = range.to;
            if (range.fromAsStr != null) {
                from = parser.parseDouble(range.fromAsStr, false, context.getQueryShardContext()::nowInMillis);
            }
            if (range.toAsStr != null) {
                to = parser.parseDouble(range.toAsStr, false, context.getQueryShardContext()::nowInMillis);
            }
            return new RangeAggregator.Range(range.key, from, range.fromAsStr, to, range.toAsStr);
        });
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new RangeAggregatorFactory(this.name, config, ranges, this.keyed, this.rangeFactory, context, parent, subFactoriesBuilder, (Map<String, Object>)this.metaData);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, false);
        PARSER.declareBoolean(AbstractRangeBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (RangeAggregator.Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> RangeAggregationBuilder.parseRange(p), RangeAggregator.RANGES_FIELD);
    }
}

