/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.threadpool;

import conductor.org.elasticsearch.common.util.concurrent.FutureUtils;
import conductor.org.elasticsearch.threadpool.Scheduler;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ScheduledCancellableAdapter
implements Scheduler.ScheduledCancellable {
    private final ScheduledFuture<?> scheduledFuture;

    ScheduledCancellableAdapter(ScheduledFuture<?> scheduledFuture) {
        assert (scheduledFuture != null);
        this.scheduledFuture = scheduledFuture;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.scheduledFuture.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed other) {
        return -other.compareTo(this.scheduledFuture);
    }

    @Override
    public boolean cancel() {
        return FutureUtils.cancel(this.scheduledFuture);
    }

    @Override
    public boolean isCancelled() {
        return this.scheduledFuture.isCancelled();
    }

    static ScheduledFuture<?> toScheduledFuture(final Scheduler.ScheduledCancellable cancellable) {
        if (cancellable instanceof ScheduledCancellableAdapter) {
            return ((ScheduledCancellableAdapter)cancellable).scheduledFuture;
        }
        return new ScheduledFuture<Object>(){

            @Override
            public long getDelay(TimeUnit unit) {
                return cancellable.getDelay(unit);
            }

            @Override
            public int compareTo(Delayed o) {
                return -o.compareTo(cancellable);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                assert (!mayInterruptIfRunning);
                return cancellable.cancel();
            }

            @Override
            public boolean isCancelled() {
                return cancellable.isCancelled();
            }

            @Override
            public boolean isDone() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object get(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

