/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.compress.CompressorFactory;
import conductor.org.elasticsearch.common.io.Streams;
import conductor.org.elasticsearch.common.io.stream.BytesStream;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import java.io.IOException;

final class CompressibleBytesOutputStream
extends StreamOutput {
    private final StreamOutput stream;
    private final BytesStream bytesStreamOutput;
    private final boolean shouldCompress;

    CompressibleBytesOutputStream(BytesStream bytesStreamOutput, boolean shouldCompress) throws IOException {
        this.bytesStreamOutput = bytesStreamOutput;
        this.shouldCompress = shouldCompress;
        this.stream = shouldCompress ? CompressorFactory.COMPRESSOR.streamOutput(Streams.flushOnCloseStream(bytesStreamOutput)) : bytesStreamOutput;
    }

    BytesReference materializeBytes() throws IOException {
        if (this.shouldCompress) {
            this.stream.close();
        }
        return this.bytesStreamOutput.bytes();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.stream.writeBytes(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != this.bytesStreamOutput) {
            assert (this.shouldCompress) : "If the streams are different we should be compressing";
            IOUtils.close(this.stream);
        }
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

