/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.core;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.core.StopFilter;
import conductor.org.apache.lucene.analysis.en.EnglishAnalyzer;
import conductor.org.apache.lucene.analysis.util.ResourceLoader;
import conductor.org.apache.lucene.analysis.util.ResourceLoaderAware;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.io.IOException;
import java.util.Map;

public class StopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String FORMAT_WORDSET = "wordset";
    public static final String FORMAT_SNOWBALL = "snowball";
    private CharArraySet stopWords;
    private final String stopWordFiles;
    private final String format;
    private final boolean ignoreCase;

    public StopFilterFactory(Map<String, String> args) {
        super(args);
        this.stopWordFiles = this.get(args, "words");
        this.format = this.get(args, "format", null == this.stopWordFiles ? null : FORMAT_WORDSET);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.stopWordFiles != null) {
            if (FORMAT_WORDSET.equalsIgnoreCase(this.format)) {
                this.stopWords = this.getWordSet(loader, this.stopWordFiles, this.ignoreCase);
                return;
            } else {
                if (!FORMAT_SNOWBALL.equalsIgnoreCase(this.format)) throw new IllegalArgumentException("Unknown 'format' specified for 'words' file: " + this.format);
                this.stopWords = this.getSnowballWordSet(loader, this.stopWordFiles, this.ignoreCase);
            }
            return;
        } else {
            if (null != this.format) {
                throw new IllegalArgumentException("'format' can not be specified w/o an explicit 'words' file: " + this.format);
            }
            this.stopWords = new CharArraySet(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getStopWords() {
        return this.stopWords;
    }

    @Override
    public TokenStream create(TokenStream input) {
        StopFilter stopFilter = new StopFilter(input, this.stopWords);
        return stopFilter;
    }
}

