/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Matches;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.MatchesUtils;
import conductor.org.apache.lucene.search.PhraseMatcher;
import conductor.org.apache.lucene.search.PhraseScorer;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.similarities.Similarity;
import java.io.IOException;

abstract class PhraseWeight
extends Weight {
    final boolean needsScores;
    final Similarity.SimWeight stats;
    final Similarity similarity;
    final String field;

    protected PhraseWeight(Query query, String field, IndexSearcher searcher, boolean needsScores) throws IOException {
        super(query);
        this.needsScores = needsScores;
        this.field = field;
        this.similarity = searcher.getSimilarity(needsScores);
        this.stats = this.getStats(searcher);
    }

    protected abstract Similarity.SimWeight getStats(IndexSearcher var1) throws IOException;

    protected abstract PhraseMatcher getPhraseMatcher(LeafReaderContext var1, boolean var2) throws IOException;

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context, false);
        if (matcher == null) {
            return null;
        }
        Similarity.SimScorer simScorer = this.similarity.simScorer(this.stats, context);
        return new PhraseScorer(this, matcher, this.needsScores, simScorer);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context, false);
        if (matcher == null || matcher.approximation.advance(doc) != doc) {
            return Explanation.noMatch("no matching terms", new Explanation[0]);
        }
        matcher.reset();
        if (!matcher.nextMatch()) {
            return Explanation.noMatch("no matching phrase", new Explanation[0]);
        }
        Similarity.SimScorer simScorer = this.similarity.simScorer(this.stats, context);
        float freq = matcher.sloppyWeight(simScorer);
        while (matcher.nextMatch()) {
            freq += matcher.sloppyWeight(simScorer);
        }
        Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
        Explanation scoreExplanation = simScorer.explain(doc, freqExplanation);
        return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return MatchesUtils.forField(this.field, () -> {
            final PhraseMatcher matcher = this.getPhraseMatcher(context, true);
            if (matcher == null || matcher.approximation.advance(doc) != doc) {
                return null;
            }
            matcher.reset();
            if (!matcher.nextMatch()) {
                return null;
            }
            return new MatchesIterator(){
                boolean started = false;

                @Override
                public boolean next() throws IOException {
                    if (!this.started) {
                        this.started = true;
                        return true;
                    }
                    return matcher.nextMatch();
                }

                @Override
                public int startPosition() {
                    return matcher.startPosition();
                }

                @Override
                public int endPosition() {
                    return matcher.endPosition();
                }

                @Override
                public int startOffset() throws IOException {
                    return matcher.startOffset();
                }

                @Override
                public int endOffset() throws IOException {
                    return matcher.endOffset();
                }

                @Override
                public MatchesIterator getSubMatches() throws IOException {
                    return null;
                }

                @Override
                public Query getQuery() {
                    return PhraseWeight.this.getQuery();
                }
            };
        });
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

