/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.spans;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermContext;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.FilterSpans;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanWeight;
import conductor.org.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class SpanPositionCheckQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery match;

    public SpanPositionCheckQuery(SpanQuery match) {
        this.match = Objects.requireNonNull(match);
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    protected abstract FilterSpans.AcceptStatus acceptPosition(Spans var1) throws IOException;

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, false, boost);
        return new SpanPositionCheckWeight(matchWeight, searcher, needsScores ? SpanPositionCheckQuery.getTermContexts(matchWeight) : null, boost);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            try {
                SpanPositionCheckQuery clone = (SpanPositionCheckQuery)this.clone();
                clone.match = rewritten;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.match.equals(((SpanPositionCheckQuery)other).match);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.match.hashCode();
    }

    public class SpanPositionCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPositionCheckWeight(SpanWeight matchWeight, IndexSearcher searcher, Map<Term, TermContext> terms, float boost) throws IOException {
            super(SpanPositionCheckQuery.this, searcher, terms, boost);
            this.matchWeight = matchWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.matchWeight.extractTerms(terms);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.matchWeight.isCacheable(ctx);
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.matchWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings);
            return matchSpans == null ? null : new FilterSpans(matchSpans){

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    return SpanPositionCheckQuery.this.acceptPosition(candidate);
                }
            };
        }
    }
}

