/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial.prefix;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.ConstantScoreWeight;
import conductor.org.apache.lucene.search.DocIdSet;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import conductor.org.apache.lucene.util.BitSet;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import java.io.IOException;
import org.locationtech.spatial4j.shape.Shape;

public abstract class AbstractPrefixTreeQuery
extends Query {
    protected final Shape queryShape;
    protected final String fieldName;
    protected final SpatialPrefixTree grid;
    protected final int detailLevel;

    public AbstractPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel) {
        this.queryShape = queryShape;
        this.fieldName = fieldName;
        this.grid = grid;
        this.detailLevel = detailLevel;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((AbstractPrefixTreeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(AbstractPrefixTreeQuery other) {
        return this.detailLevel == other.detailLevel && this.fieldName.equals(other.fieldName) && this.queryShape.equals((Object)other.queryShape);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.queryShape.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet docSet = AbstractPrefixTreeQuery.this.getDocIdSet(context);
                if (docSet == null) {
                    return null;
                }
                DocIdSetIterator disi = docSet.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    protected abstract DocIdSet getDocIdSet(LeafReaderContext var1) throws IOException;

    public abstract class BaseTermsEnumTraverser {
        protected final LeafReaderContext context;
        protected final int maxDoc;
        protected final Terms terms;
        protected final TermsEnum termsEnum;
        protected PostingsEnum postingsEnum;

        public BaseTermsEnumTraverser(LeafReaderContext context) throws IOException {
            this.context = context;
            LeafReader reader = context.reader();
            this.maxDoc = reader.maxDoc();
            this.terms = reader.terms(AbstractPrefixTreeQuery.this.fieldName);
            this.termsEnum = this.terms != null ? this.terms.iterator() : null;
        }

        protected void collectDocs(BitSet bitSet) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            bitSet.or(this.postingsEnum);
        }

        protected void collectDocs(DocIdSetBuilder docSetBuilder) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            docSetBuilder.add(this.postingsEnum);
        }
    }
}

