/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.tasks.get;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.tasks.TaskResult;
import java.io.IOException;
import java.util.Objects;

public class GetTaskResponse
extends ActionResponse
implements ToXContentObject {
    private TaskResult task;

    public GetTaskResponse() {
    }

    public GetTaskResponse(TaskResult task) {
        this.task = Objects.requireNonNull(task, "task is required");
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.task = in.readOptionalWriteable(TaskResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.task);
    }

    public TaskResult getTask() {
        return this.task;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.task.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }
}

