/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.ingest;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import conductor.org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import conductor.org.elasticsearch.action.ingest.PutPipelineRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.ingest.IngestInfo;
import conductor.org.elasticsearch.ingest.IngestService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.HashMap;

public class PutPipelineTransportAction
extends TransportMasterNodeAction<PutPipelineRequest, AcknowledgedResponse> {
    private final IngestService ingestService;
    private final ClusterService clusterService;
    private final TransportNodesInfoAction nodesInfoAction;

    @Inject
    public PutPipelineTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IngestService ingestService, TransportNodesInfoAction nodesInfoAction) {
        super(settings, "cluster:admin/ingest/pipeline/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutPipelineRequest::new);
        this.clusterService = clusterService;
        this.nodesInfoAction = nodesInfoAction;
        this.ingestService = ingestService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    @Override
    protected void masterOperation(final PutPipelineRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
        nodesInfoRequest.clear();
        nodesInfoRequest.ingest(true);
        this.nodesInfoAction.execute(nodesInfoRequest, new ActionListener<NodesInfoResponse>(){

            @Override
            public void onResponse(NodesInfoResponse nodeInfos) {
                try {
                    HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
                    for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                        ingestInfos.put(nodeInfo.getNode(), nodeInfo.getIngest());
                    }
                    PutPipelineTransportAction.this.ingestService.putPipeline(ingestInfos, request, listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(PutPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

