/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class InvalidateTokenResponse {
    public static final ParseField CREATED = new ParseField("created", new String[0]);
    public static final ParseField INVALIDATED_TOKENS = new ParseField("invalidated_tokens", new String[0]);
    public static final ParseField PREVIOUSLY_INVALIDATED_TOKENS = new ParseField("previously_invalidated_tokens", new String[0]);
    public static final ParseField ERROR_COUNT = new ParseField("error_count", new String[0]);
    public static final ParseField ERRORS = new ParseField("error_details", new String[0]);
    private final boolean created;
    private final int invalidatedTokens;
    private final int previouslyInvalidatedTokens;
    private List<ElasticsearchException> errors;
    private static final ConstructingObjectParser<InvalidateTokenResponse, Void> PARSER = new ConstructingObjectParser("tokens_invalidation_result", true, args -> new InvalidateTokenResponse((Boolean)args[0], (Integer)args[1], (Integer)args[2], (List)args[4]));

    public InvalidateTokenResponse(boolean created, int invalidatedTokens, int previouslyInvalidatedTokens, @Nullable List<ElasticsearchException> errors) {
        this.created = created;
        this.invalidatedTokens = invalidatedTokens;
        this.previouslyInvalidatedTokens = previouslyInvalidatedTokens;
        this.errors = null == errors ? Collections.emptyList() : Collections.unmodifiableList(errors);
    }

    public boolean isCreated() {
        return this.created;
    }

    public int getInvalidatedTokens() {
        return this.invalidatedTokens;
    }

    public int getPreviouslyInvalidatedTokens() {
        return this.previouslyInvalidatedTokens;
    }

    public List<ElasticsearchException> getErrors() {
        return this.errors;
    }

    public int getErrorsCount() {
        return this.errors == null ? 0 : this.errors.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidateTokenResponse that = (InvalidateTokenResponse)o;
        return this.created == that.created && this.invalidatedTokens == that.invalidatedTokens && this.previouslyInvalidatedTokens == that.previouslyInvalidatedTokens && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.invalidatedTokens, this.previouslyInvalidatedTokens, this.errors);
    }

    public static InvalidateTokenResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), CREATED);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), INVALIDATED_TOKENS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PREVIOUSLY_INVALIDATED_TOKENS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), ERROR_COUNT);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), ERRORS);
    }
}

