/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing;

import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.ShardRoutingState;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class RoutingNode
implements Iterable<ShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final LinkedHashMap<ShardId, ShardRouting> shards;

    public RoutingNode(String nodeId, DiscoveryNode node, ShardRouting ... shards) {
        this(nodeId, node, RoutingNode.buildShardRoutingMap(shards));
    }

    RoutingNode(String nodeId, DiscoveryNode node, LinkedHashMap<ShardId, ShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
    }

    private static LinkedHashMap<ShardId, ShardRouting> buildShardRoutingMap(ShardRouting ... shardRoutings) {
        LinkedHashMap<ShardId, ShardRouting> shards = new LinkedHashMap<ShardId, ShardRouting>();
        for (ShardRouting shardRouting : shardRoutings) {
            ShardRouting previousValue = shards.put(shardRouting.shardId(), shardRouting);
            if (previousValue == null) continue;
            throw new IllegalArgumentException("Cannot have two different shards with same shard id " + shardRouting.shardId() + " on same node ");
        }
        return shards;
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return Collections.unmodifiableCollection(this.shards.values()).iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    @Nullable
    public ShardRouting getByShardId(ShardId id) {
        return this.shards.get(id);
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int size() {
        return this.shards.size();
    }

    void add(ShardRouting shard) {
        if (this.shards.containsKey(shard.shardId())) {
            throw new IllegalStateException("Trying to add a shard " + shard.shardId() + " to a node [" + this.nodeId + "] where it already exists. current [" + this.shards.get(shard.shardId()) + "]. new [" + shard + "]");
        }
        this.shards.put(shard.shardId(), shard);
    }

    void update(ShardRouting oldShard, ShardRouting newShard) {
        if (!this.shards.containsKey(oldShard.shardId())) {
            return;
        }
        ShardRouting previousValue = this.shards.put(newShard.shardId(), newShard);
        assert (previousValue == oldShard) : "expected shard " + previousValue + " but was " + oldShard;
    }

    void remove(ShardRouting shard) {
        ShardRouting previousValue = (ShardRouting)this.shards.remove(shard.shardId());
        assert (previousValue == shard) : "expected shard " + previousValue + " but was " + shard;
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        int count = 0;
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                ++count;
            }
        }
        return count;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(String index, ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            if (!shardEntry.getIndexName().equals(index)) continue;
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfOwningShards() {
        int count = 0;
        for (ShardRouting shardEntry : this) {
            if (shardEntry.state() == ShardRoutingState.RELOCATING) continue;
            ++count;
        }
        return count;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][").append(this.node == null ? "X" : "V").append("]\n");
        for (ShardRouting entry : this.shards.values()) {
            sb.append("--------").append(entry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("routingNode ([");
        sb.append(this.node.getName());
        sb.append("][");
        sb.append(this.node.getId());
        sb.append("][");
        sb.append(this.node.getHostName());
        sb.append("][");
        sb.append(this.node.getHostAddress());
        sb.append("], [");
        sb.append(this.shards.size());
        sb.append(" assigned shards])");
        return sb.toString();
    }

    public List<ShardRouting> copyShards() {
        return new ArrayList<ShardRouting>(this.shards.values());
    }

    public boolean isEmpty() {
        return this.shards.isEmpty();
    }
}

