/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.spi;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.internal.SourceProvider;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.ElementVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Message
implements Element {
    private final String message;
    private final Throwable cause;
    private final List<Object> sources;

    public Message(List<Object> sources, String message, Throwable cause) {
        this.sources = Collections.unmodifiableList(sources);
        this.message = Objects.requireNonNull(message, "message");
        this.cause = cause;
    }

    public Message(Object source, String message) {
        this(Collections.singletonList(source), message, null);
    }

    public Message(Object source, Throwable cause) {
        this(Collections.singletonList(source), null, cause);
    }

    public Message(String message) {
        this(Collections.emptyList(), message, null);
    }

    @Override
    public String getSource() {
        return this.sources.isEmpty() ? SourceProvider.UNKNOWN_SOURCE.toString() : Errors.convert(this.sources.get(this.sources.size() - 1)).toString();
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message e = (Message)o;
        return this.message.equals(e.message) && Objects.equals(this.cause, e.cause) && this.sources.equals(e.sources);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).addError(this);
    }
}

