/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.rankeval;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.IndexScopedSettings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsFilter;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.index.rankeval.DiscountedCumulativeGain;
import conductor.org.elasticsearch.index.rankeval.EvaluationMetric;
import conductor.org.elasticsearch.index.rankeval.ExpectedReciprocalRank;
import conductor.org.elasticsearch.index.rankeval.MeanReciprocalRank;
import conductor.org.elasticsearch.index.rankeval.MetricDetail;
import conductor.org.elasticsearch.index.rankeval.PrecisionAtK;
import conductor.org.elasticsearch.index.rankeval.RankEvalAction;
import conductor.org.elasticsearch.index.rankeval.RankEvalNamedXContentProvider;
import conductor.org.elasticsearch.index.rankeval.RankEvalRequest;
import conductor.org.elasticsearch.index.rankeval.RankEvalResponse;
import conductor.org.elasticsearch.index.rankeval.RestRankEvalAction;
import conductor.org.elasticsearch.index.rankeval.TransportRankEvalAction;
import conductor.org.elasticsearch.plugins.ActionPlugin;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class RankEvalPlugin
extends Plugin
implements ActionPlugin {
    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler<RankEvalRequest, RankEvalResponse>(RankEvalAction.INSTANCE, TransportRankEvalAction.class, new Class[0]));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestRankEvalAction(settings, restController));
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "precision", PrecisionAtK::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "mean_reciprocal_rank", MeanReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "dcg", DiscountedCumulativeGain::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "expected_reciprocal_rank", ExpectedReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "precision", PrecisionAtK.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "mean_reciprocal_rank", MeanReciprocalRank.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "dcg", DiscountedCumulativeGain.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "expected_reciprocal_rank", ExpectedReciprocalRank.Detail::new));
        return namedWriteables;
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new RankEvalNamedXContentProvider().getNamedXContentParsers();
    }
}

