/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.join.aggregations;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.util.BitArray;
import conductor.org.elasticsearch.common.util.LongHash;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class ParentJoinAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Weight inFilter;
    private final Weight outFilter;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final boolean singleAggregator;
    private final LongHash ordsHash;
    private final BitArray ordsBit;

    public ParentJoinAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Query inFilter, Query outFilter, ValuesSource.Bytes.WithOrdinals valuesSource, long maxOrd, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        if (maxOrd > Integer.MAX_VALUE) {
            throw new IllegalStateException("the number of parent [" + maxOrd + "] + is greater than the allowed limit for this aggregation: " + Integer.MAX_VALUE);
        }
        this.inFilter = context.searcher().createWeight(context.searcher().rewrite(inFilter), false, 1.0f);
        this.outFilter = context.searcher().createWeight(context.searcher().rewrite(outFilter), false, 1.0f);
        this.valuesSource = valuesSource;
        this.singleAggregator = parent == null;
        this.ordsBit = this.singleAggregator ? new BitArray((int)maxOrd, context.bigArrays()) : null;
        this.ordsHash = this.singleAggregator ? null : new LongHash(1L, context.bigArrays());
    }

    private void addGlobalOrdinal(int globalOrdinal) {
        if (this.singleAggregator) {
            this.ordsBit.set(globalOrdinal);
        } else {
            this.ordsHash.add(globalOrdinal);
        }
    }

    private boolean existsGlobalOrdinal(int globalOrdinal) {
        return this.singleAggregator ? this.ordsBit.get(globalOrdinal) : this.ordsHash.find(globalOrdinal) >= 0L;
    }

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.inFilter.scorerSupplier(ctx));
        return new LeafBucketCollector(){

            @Override
            public void collect(int docId, long bucket) throws IOException {
                assert (bucket == 0L);
                if (parentDocs.get(docId) && globalOrdinals.advanceExact(docId)) {
                    int globalOrdinal = (int)globalOrdinals.nextOrd();
                    assert (globalOrdinal != -1 && globalOrdinals.nextOrd() == -1L);
                    ParentJoinAggregator.this.addGlobalOrdinal(globalOrdinal);
                }
            }
        };
    }

    @Override
    protected final void doPostCollection() throws IOException {
        IndexReader indexReader = this.context().searcher().getIndexReader();
        for (LeafReaderContext ctx : indexReader.leaves()) {
            Scorer childDocsScorer = this.outFilter.scorer(ctx);
            if (childDocsScorer == null) continue;
            DocIdSetIterator childDocsIter = childDocsScorer.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
            SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
            sub.setScorer(new ConstantScoreScorer(null, 1.0f, childDocsIter));
            Bits liveDocs = ctx.reader().getLiveDocs();
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if ((liveDocs == null || liveDocs.get(docId)) && globalOrdinals.advanceExact(docId)) {
                    int globalOrdinal = (int)globalOrdinals.nextOrd();
                    assert (globalOrdinal != -1 && globalOrdinals.nextOrd() == -1L);
                    if (this.existsGlobalOrdinal(globalOrdinal)) {
                        this.collectBucket(sub, docId, 0L);
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
    }

    @Override
    protected void doClose() {
        Releasables.close(this.ordsBit, this.ordsHash);
    }
}

