/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.percolator;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.ScorerSupplier;
import conductor.org.apache.lucene.search.TopDocs;
import conductor.org.apache.lucene.search.TwoPhaseIterator;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.lucene.Lucene;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class PercolateQuery
extends Query
implements Accountable {
    private static final float MATCH_COST = 1000.0f;
    private final String name;
    private final QueryStore queryStore;
    private final List<BytesReference> documents;
    private final Query candidateMatchesQuery;
    private final Query verifiedMatchesQuery;
    private final IndexSearcher percolatorIndexSearcher;
    private final Query nonNestedDocsFilter;

    PercolateQuery(String name, QueryStore queryStore, List<BytesReference> documents, Query candidateMatchesQuery, IndexSearcher percolatorIndexSearcher, Query nonNestedDocsFilter, Query verifiedMatchesQuery) {
        this.name = name;
        this.documents = Objects.requireNonNull(documents);
        this.candidateMatchesQuery = Objects.requireNonNull(candidateMatchesQuery);
        this.queryStore = Objects.requireNonNull(queryStore);
        this.percolatorIndexSearcher = Objects.requireNonNull(percolatorIndexSearcher);
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.verifiedMatchesQuery = Objects.requireNonNull(verifiedMatchesQuery);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.candidateMatchesQuery.rewrite(reader);
        if (rewritten != this.candidateMatchesQuery) {
            return new PercolateQuery(this.name, this.queryStore, this.documents, rewritten, this.percolatorIndexSearcher, this.nonNestedDocsFilter, this.verifiedMatchesQuery);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final boolean needsScores, float boost) throws IOException {
        final Weight verifiedMatchesWeight = this.verifiedMatchesQuery.createWeight(searcher, false, boost);
        final Weight candidateMatchesWeight = this.candidateMatchesQuery.createWeight(searcher, false, boost);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> set) {
            }

            @Override
            public Explanation explain(LeafReaderContext leafReaderContext, int docId) throws IOException {
                TwoPhaseIterator twoPhaseIterator;
                int result;
                Scorer scorer = this.scorer(leafReaderContext);
                if (scorer != null && (result = (twoPhaseIterator = scorer.twoPhaseIterator()).approximation().advance(docId)) == docId && twoPhaseIterator.matches()) {
                    if (needsScores) {
                        CheckedFunction<Integer, Query, IOException> percolatorQueries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                        Query query = percolatorQueries.apply(docId);
                        Explanation detail = PercolateQuery.this.percolatorIndexSearcher.explain(query, 0);
                        return Explanation.match(scorer.score(), "PercolateQuery", detail);
                    }
                    return Explanation.match(scorer.score(), "PercolateQuery", new Explanation[0]);
                }
                return Explanation.noMatch("PercolateQuery", new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                Scorer approximation = candidateMatchesWeight.scorer(leafReaderContext);
                if (approximation == null) {
                    return null;
                }
                CheckedFunction<Integer, Query, IOException> queries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                if (needsScores) {
                    return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){
                        float score;

                        @Override
                        boolean matchDocId(int docId) throws IOException {
                            Query query = (Query)this.percolatorQueries.apply(docId);
                            if (query != null) {
                                if (PercolateQuery.this.nonNestedDocsFilter != null) {
                                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(PercolateQuery.this.nonNestedDocsFilter, BooleanClause.Occur.FILTER).build();
                                }
                                TopDocs topDocs = this.percolatorIndexSearcher.search(query, 1);
                                if (topDocs.totalHits > 0L) {
                                    this.score = topDocs.scoreDocs[0].score;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }

                        @Override
                        public float score() throws IOException {
                            return this.score;
                        }
                    };
                }
                ScorerSupplier verifiedDocsScorer = verifiedMatchesWeight.scorerSupplier(leafReaderContext);
                final Bits verifiedDocsBits = Lucene.asSequentialAccessBits(leafReaderContext.reader().maxDoc(), verifiedDocsScorer);
                return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    boolean matchDocId(int docId) throws IOException {
                        if (verifiedDocsBits.get(docId)) {
                            return true;
                        }
                        Query query = (Query)this.percolatorQueries.apply(docId);
                        if (query == null) {
                            return false;
                        }
                        if (PercolateQuery.this.nonNestedDocsFilter != null) {
                            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(PercolateQuery.this.nonNestedDocsFilter, BooleanClause.Occur.FILTER).build();
                        }
                        return Lucene.exists(this.percolatorIndexSearcher, query);
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    String getName() {
        return this.name;
    }

    IndexSearcher getPercolatorIndexSearcher() {
        return this.percolatorIndexSearcher;
    }

    boolean excludesNestedDocs() {
        return this.nonNestedDocsFilter != null;
    }

    List<BytesReference> getDocuments() {
        return this.documents;
    }

    QueryStore getQueryStore() {
        return this.queryStore;
    }

    Query getCandidateMatchesQuery() {
        return this.candidateMatchesQuery;
    }

    Query getVerifiedMatchesQuery() {
        return this.verifiedMatchesQuery;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString(String s) {
        StringBuilder sources = new StringBuilder();
        for (BytesReference document : this.documents) {
            sources.append(document.utf8ToString());
            sources.append('\n');
        }
        return "PercolateQuery{document_sources={" + sources + "},inner={" + this.candidateMatchesQuery.toString(s) + "}}";
    }

    @Override
    public long ramBytesUsed() {
        long ramUsed = 0L;
        for (BytesReference document : this.documents) {
            ramUsed += document.ramBytesUsed();
        }
        return ramUsed;
    }

    static abstract class BaseScorer
    extends Scorer {
        final Scorer approximation;
        final CheckedFunction<Integer, Query, IOException> percolatorQueries;
        final IndexSearcher percolatorIndexSearcher;

        BaseScorer(Weight weight, Scorer approximation, CheckedFunction<Integer, Query, IOException> percolatorQueries, IndexSearcher percolatorIndexSearcher) {
            super(weight);
            this.approximation = approximation;
            this.percolatorQueries = percolatorQueries;
            this.percolatorIndexSearcher = percolatorIndexSearcher;
        }

        @Override
        public final DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
        }

        @Override
        public final TwoPhaseIterator twoPhaseIterator() {
            return new TwoPhaseIterator(this.approximation.iterator()){

                @Override
                public boolean matches() throws IOException {
                    return this.matchDocId(this.approximation.docID());
                }

                @Override
                public float matchCost() {
                    return 1000.0f;
                }
            };
        }

        @Override
        public final int docID() {
            return this.approximation.docID();
        }

        abstract boolean matchDocId(int var1) throws IOException;
    }

    @FunctionalInterface
    static interface QueryStore {
        public CheckedFunction<Integer, Query, IOException> getQueries(LeafReaderContext var1) throws IOException;
    }
}

