/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.query;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import java.io.IOException;

public final class ScrollQuerySearchResult
extends SearchPhaseResult {
    private QuerySearchResult result;

    public ScrollQuerySearchResult() {
    }

    public ScrollQuerySearchResult(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public ScrollQuerySearchResult(QuerySearchResult result, SearchShardTarget shardTarget) {
        this.result = result;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.result.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int shardIndex) {
        super.setShardIndex(shardIndex);
        this.result.setShardIndex(shardIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        SearchShardTarget shardTarget = new SearchShardTarget(in);
        this.result = QuerySearchResult.readQuerySearchResult(in);
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.getSearchShardTarget().writeTo(out);
        this.result.writeTo(out);
    }
}

