/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.sort;

import conductor.org.apache.lucene.search.SortField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.sort.SortBuilder;
import conductor.org.elasticsearch.search.sort.SortFieldAndFormat;
import conductor.org.elasticsearch.search.sort.SortOrder;
import java.io.IOException;
import java.util.Objects;

public class ScoreSortBuilder
extends SortBuilder<ScoreSortBuilder> {
    public static final String NAME = "_score";
    private static final SortFieldAndFormat SORT_SCORE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_SCORE_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE, true), DocValueFormat.RAW);
    private static ObjectParser<ScoreSortBuilder, Void> PARSER = new ObjectParser("_score", ScoreSortBuilder::new);

    public ScoreSortBuilder() {
        this.order(SortOrder.DESC);
    }

    public ScoreSortBuilder(StreamInput in) throws IOException {
        this.order(SortOrder.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScoreSortBuilder fromXContent(XContentParser parser, String fieldName) {
        return PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) {
        if (this.order == SortOrder.DESC) {
            return SORT_SCORE;
        }
        return SORT_SCORE_REVERSE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScoreSortBuilder other = (ScoreSortBuilder)object;
        return Objects.equals(this.order, other.order);
    }

    public int hashCode() {
        return Objects.hash(this.order);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public ScoreSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        return this;
    }

    static {
        PARSER.declareString((builder, order) -> builder.order(SortOrder.fromString(order)), ORDER_FIELD);
    }
}

