/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.bootstrap.Bootstrap;
import conductor.io.netty.bootstrap.ServerBootstrap;
import conductor.io.netty.channel.AdaptiveRecvByteBufAllocator;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.channel.ChannelHandler;
import conductor.io.netty.channel.ChannelHandlerAdapter;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.channel.ChannelInitializer;
import conductor.io.netty.channel.ChannelOption;
import conductor.io.netty.channel.FixedRecvByteBufAllocator;
import conductor.io.netty.channel.RecvByteBufAllocator;
import conductor.io.netty.channel.nio.NioEventLoopGroup;
import conductor.io.netty.channel.socket.nio.NioServerSocketChannel;
import conductor.io.netty.channel.socket.nio.NioSocketChannel;
import conductor.io.netty.util.AttributeKey;
import conductor.io.netty.util.concurrent.Future;
import conductor.io.netty.util.concurrent.GenericFutureListener;
import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.network.NetworkService;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.ByteSizeUnit;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.util.PageCacheRecycler;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.common.util.concurrent.EsExecutors;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.TransportSettings;
import conductor.org.elasticsearch.transport.netty4.ESLoggingHandler;
import conductor.org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import conductor.org.elasticsearch.transport.netty4.Netty4SizeHeaderFrameDecoder;
import conductor.org.elasticsearch.transport.netty4.Netty4TcpChannel;
import conductor.org.elasticsearch.transport.netty4.Netty4TcpServerChannel;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Netty4Transport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(Netty4Transport.class);
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int workerCount;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    private volatile Bootstrap clientBootstrap;
    private volatile NioEventLoopGroup eventLoopGroup;
    static final AttributeKey<Netty4TcpChannel> CHANNEL_KEY;
    static final AttributeKey<Netty4TcpServerChannel> SERVER_CHANNEL_KEY;

    public Netty4Transport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty", settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors(EsExecutors.PROCESSORS_SETTING.get(settings));
        this.workerCount = WORKER_COUNT.get(settings);
        this.receivePredictorMin = NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, "transport_worker");
            this.eventLoopGroup = new NioEventLoopGroup(this.workerCount, threadFactory);
            this.clientBootstrap = this.createClientBootstrap(this.eventLoopGroup);
            if (NetworkService.NETWORK_SERVER.get(this.settings).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings, this.eventLoopGroup);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap(NioEventLoopGroup eventLoopGroup) {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.TCP_NODELAY, TransportSettings.TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, TransportSettings.TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        boolean reuseAddress = TransportSettings.TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings, NioEventLoopGroup eventLoopGroup) {
        String name = profileSettings.profileName;
        if (logger.isDebugEnabled()) {
            logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], receive_predictor[{}->{}]", (Object)name, (Object)this.workerCount, (Object)profileSettings.portOrRange, (Object)profileSettings.bindHosts, (Object)profileSettings.publishHosts, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(eventLoopGroup);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.handler(new ServerChannelExceptionHandler());
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, profileSettings.tcpKeepAlive);
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new ClientChannelInitializer();
    }

    @Override
    protected Netty4TcpChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.clientBootstrap.clone();
        bootstrapWithHandler.handler(this.getClientChannelInitializer(node));
        bootstrapWithHandler.remoteAddress(address);
        ChannelFuture connectFuture = bootstrapWithHandler.connect();
        Channel channel = connectFuture.channel();
        if (channel == null) {
            ExceptionsHelper.maybeDieOnAnotherThread(connectFuture.cause());
            throw new IOException(connectFuture.cause());
        }
        this.addClosedExceptionLogger(channel);
        Netty4TcpChannel nettyChannel = new Netty4TcpChannel(channel, false, "default", connectFuture);
        channel.attr(CHANNEL_KEY).set(nettyChannel);
        return nettyChannel;
    }

    @Override
    protected Netty4TcpServerChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind(address).syncUninterruptibly().channel();
        Netty4TcpServerChannel esChannel = new Netty4TcpServerChannel(channel, name);
        channel.attr(SERVER_CHANNEL_KEY).set(esChannel);
        return esChannel;
    }

    @Override
    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close(() -> {
            Future<?> shutdownFuture = this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            shutdownFuture.awaitUninterruptibly();
            if (!shutdownFuture.isSuccess()) {
                logger.warn("Error closing netty event loop group", shutdownFuture.cause());
            }
            this.serverBootstraps.clear();
            this.clientBootstrap = null;
        });
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (!f.isSuccess()) {
                logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        }));
    }

    static {
        Netty4Utils.setup();
        WORKER_COUNT = new Setting<Integer>("transport.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors(s) * 2), s -> Setting.parseInt(s, 1, "transport.netty.worker_count"), Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("transport.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
        NETTY_BOSS_COUNT = Setting.intSetting("transport.netty.boss_count", 1, 1, Setting.Property.NodeScope);
        CHANNEL_KEY = AttributeKey.newInstance("es-channel");
        SERVER_CHANNEL_KEY = AttributeKey.newInstance("es-server-channel");
    }

    @ChannelHandler.Sharable
    private class ServerChannelExceptionHandler
    extends ChannelHandlerAdapter {
        private ServerChannelExceptionHandler() {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            Netty4TcpServerChannel serverChannel = ctx.channel().attr(SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4Transport.this.onServerException(serverChannel, new Exception(cause));
            } else {
                Netty4Transport.this.onServerException(serverChannel, (Exception)cause);
            }
        }
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            Netty4TcpChannel nettyTcpChannel = new Netty4TcpChannel(ch, true, this.name, ch.newSucceededFuture());
            ch.attr(CHANNEL_KEY).set(nettyTcpChannel);
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

