/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es6.dao.query.parser.internal;

import com.netflix.conductor.es6.dao.query.parser.internal.AbstractNode;
import com.netflix.conductor.es6.dao.query.parser.internal.ParserException;
import java.io.InputStream;

public class Range
extends AbstractNode {
    private String low;
    private String high;

    public Range(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        this.low = this.readNumber(this.is);
        this.skipWhitespace();
        byte[] peeked = this.read(3);
        this.assertExpected(peeked, "AND");
        this.skipWhitespace();
        String num = this.readNumber(this.is);
        if ("".equals(num)) {
            throw new ParserException("Missing the upper range value...");
        }
        this.high = num;
    }

    private String readNumber(InputStream is) throws Exception {
        StringBuilder sb = new StringBuilder();
        while (is.available() > 0) {
            is.mark(1);
            char c = (char)is.read();
            if (!this.isNumeric(c)) {
                is.reset();
                break;
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    public String getLow() {
        return this.low;
    }

    public String getHigh() {
        return this.high;
    }

    public String toString() {
        return this.low + " AND " + this.high;
    }
}

